/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomConfig;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomConfigManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.SpaceToRoomNotification;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationContext2;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.plugins.hipchat.api.notification.RoomToNotify;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class SpaceNotificationContext<T>
implements HipChatNotificationContext2<T> {
    public static final String KEY = "space";
    private SpaceToRoomNotificationProvider spaceToRoomNotificationProvider;
    private EntityToRoomMappingManager entityToRoomMappingManager;
    private EntityToRoomConfigManager entityToRoomConfigManager;

    public Iterable<String> getRoomIds(T event, NotificationType notificationType) {
        Option<Pair<Space, Iterable<String>>> spaceRoomsOption = this.getSpaceAndRoomsToNotify(event, notificationType);
        if (spaceRoomsOption.isEmpty()) {
            return Collections.emptyList();
        }
        return (Iterable)((Pair)spaceRoomsOption.get()).right();
    }

    public Iterable<RoomToNotify> getRoomToNotify(T event, NotificationType notificationType) {
        Option<Pair<Space, Iterable<String>>> spaceRoomsOption = this.getSpaceAndRoomsToNotify(event, notificationType);
        if (spaceRoomsOption.isEmpty()) {
            return Collections.emptyList();
        }
        Pair spaceRooms = (Pair)spaceRoomsOption.get();
        final HashSet<String> roomsIdsToNotify = new HashSet<String>();
        Iterable<AOEntityToRoomConfig> roomConfigs = this.entityToRoomConfigManager.getForEntity(((Space)spaceRooms.left()).getKey());
        for (AOEntityToRoomConfig config : roomConfigs) {
            if (!config.isNotifyClient()) continue;
            roomsIdsToNotify.add(config.getRoomId());
        }
        return Iterables.transform((Iterable)((Iterable)spaceRooms.right()), (Function)new Function<String, RoomToNotify>(){

            public RoomToNotify apply(String roomId) {
                return new RoomToNotify.Builder().setRoomId(roomId).setNotify(roomsIdsToNotify.contains(roomId)).build();
            }
        });
    }

    private Option<Pair<Space, Iterable<String>>> getSpaceAndRoomsToNotify(T event, NotificationType notificationType) {
        List emptyRoomIds = Collections.emptyList();
        Option notificationOption = notificationType.getNotification();
        if (notificationOption.isEmpty()) {
            return Option.none();
        }
        if (!(notificationOption.get() instanceof SpaceToRoomNotification)) {
            return Option.none();
        }
        SpaceToRoomNotification notification = (SpaceToRoomNotification)notificationOption.get();
        Option<Space> space = notification.getSpace(event);
        if (space.isEmpty()) {
            return Option.none();
        }
        Iterable<AOEntityToRoomMapping> rooms = this.entityToRoomMappingManager.getForEntityAndType(((Space)space.get()).getKey(), notificationType);
        Iterable roomIds = Iterables.transform(rooms, (Function)new Function<AOEntityToRoomMapping, String>(){

            public String apply(AOEntityToRoomMapping mapping) {
                return mapping.getRoomId();
            }
        });
        return Option.some((Object)Pair.pair((Object)space.get(), (Object)roomIds));
    }

    public void setEntityToRoomMappingManager(EntityToRoomMappingManager entityToRoomMappingManager) {
        this.entityToRoomMappingManager = entityToRoomMappingManager;
    }

    public void setEntityToRoomConfigManager(EntityToRoomConfigManager entityToRoomConfigManager) {
        this.entityToRoomConfigManager = entityToRoomConfigManager;
    }

    public void setSpaceToRoomNotificationProvider(SpaceToRoomNotificationProvider spaceToRoomNotificationProvider) {
        this.spaceToRoomNotificationProvider = spaceToRoomNotificationProvider;
    }
}

