/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.ContentCardBuilder;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.SpaceToRoomNotification;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatContentPermissionChecker;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.cards.Card;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;

public abstract class ContentNotification<T>
extends SpaceToRoomNotification<T> {
    private ApplicationProperties applicationProperties;
    private HipChatContentPermissionChecker permissionChecker;
    private ContentCardBuilder contentCardBuilder;

    protected abstract AbstractPage getAbstractPage(T var1);

    protected Option<UserKey> getNotifyingUser(T event) {
        return Option.none();
    }

    @Override
    public final Option<Space> getSpace(T event) {
        return Option.some((Object)this.getAbstractPage(event).getSpace());
    }

    @Override
    public final Option<UserKey> getUser(T event) {
        ConfluenceUser user;
        Option<UserKey> notifyingUser = this.getNotifyingUser(event);
        if (notifyingUser.isDefined()) {
            return notifyingUser;
        }
        AbstractPage page = this.getAbstractPage(event);
        ConfluenceUser confluenceUser = user = page.isNew() ? page.getCreator() : page.getLastModifier();
        if (user != null) {
            return Option.some((Object)user.getKey());
        }
        return Option.none();
    }

    public final boolean isPermitted(T event) {
        return !this.permissionChecker.doesContentHaveViewRestrictions(this.getAbstractPage(event));
    }

    @Override
    public String getLink(T event) {
        AbstractPage page = this.getAbstractPage(event);
        return String.format("<a href=\"%s\">%s</a>", GeneralUtil.escapeForHtmlAttribute((String)this.tinyLink(page)), GeneralUtil.escapeXMLCharacters((String)page.getTitle()));
    }

    public Option<String> getActivityKey(T event) {
        return Option.none();
    }

    @Override
    public Option<Card> getCard(T event) {
        Option<String> activityKey = this.getActivityKey(event);
        if (activityKey.isEmpty()) {
            return Option.none();
        }
        Option<String> activityText = this.notificationMessageBuilder.buildActivityText((String)activityKey.get(), this, event);
        if (activityText.isEmpty()) {
            return Option.none();
        }
        AbstractPage content = this.getAbstractPage(event);
        Option<UserKey> user = this.getUser(event);
        return this.contentCardBuilder.buildActivityCard(content, (String)activityText.get(), user);
    }

    private String tinyLink(AbstractPage page) {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/x/" + new TinyUrl(page).getIdentifier();
    }

    public void setApplicationProperties(ApplicationProperties applicationProperties) {
        Preconditions.checkNotNull((Object)applicationProperties);
        this.applicationProperties = applicationProperties;
    }

    public void setPermissionChecker(HipChatContentPermissionChecker permissionChecker) {
        Preconditions.checkNotNull((Object)permissionChecker);
        this.permissionChecker = permissionChecker;
    }

    public void setContentCardBuilder(ContentCardBuilder contentCardBuilder) {
        this.contentCardBuilder = contentCardBuilder;
    }
}

