/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.model;

import com.google.common.base.Preconditions;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
public final class MappedSpace
implements Comparable<MappedSpace> {
    @JsonProperty
    private final String spaceKey;
    @JsonProperty
    private final String spaceName;

    @JsonCreator
    public MappedSpace(@JsonProperty(value="spaceKey") String spaceKey, @JsonProperty(value="spaceName") String spaceName) {
        this.spaceKey = spaceKey;
        this.spaceName = spaceName;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedSpace item = (MappedSpace)o;
        return !(this.spaceKey != null ? !this.spaceKey.equals(item.spaceKey) : item.spaceKey != null);
    }

    public int hashCode() {
        return this.spaceKey.hashCode();
    }

    public String toString() {
        return "ConfluenceContentItems{spaceKey=" + this.spaceKey + ", spaceName='" + this.spaceName + '\'' + '}';
    }

    @Override
    public int compareTo(MappedSpace other) {
        Preconditions.checkNotNull((Object)other);
        int comparison = this.spaceName.compareTo(other.getSpaceName());
        if (comparison == 0) {
            comparison = this.spaceKey.compareTo(other.getSpaceKey());
        }
        return comparison;
    }
}

