/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.impl;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.ContentCardBuilder;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.NotificationMessageBuilder;
import com.atlassian.confluence.plugins.hipchat.util.LinkHelper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceLogoManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.cards.Card;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultContentCardBuilder
implements ContentCardBuilder {
    private final ApplicationProperties applicationProperties;
    private final NotificationMessageBuilder notificationMessageBuilder;
    private final SpaceLogoManager spaceLogoManager;

    public DefaultContentCardBuilder(ApplicationProperties applicationProperties, NotificationMessageBuilder notificationMessageBuilder, SpaceLogoManager spaceLogoManager) {
        this.applicationProperties = applicationProperties;
        this.notificationMessageBuilder = notificationMessageBuilder;
        this.spaceLogoManager = spaceLogoManager;
    }

    @Override
    public Option<Card> buildActivityCard(AbstractPage content, String activityText, Option<UserKey> actor) {
        try {
            URL link = LinkHelper.tinyLink(content, this.applicationProperties);
            Card.Builder builder = Card.builder((Card.Style)Card.Style.application, (URL)link, (String)link.toString());
            Option<URL> activityIconUrl = Option.none();
            activityIconUrl = actor.isDefined() ? this.notificationMessageBuilder.getUserAvatar((UserKey)actor.get()) : this.notificationMessageBuilder.getDefaultUserAvatar();
            builder.setActivity((Card.Activity)new Card.HtmlActivity(activityText, activityIconUrl));
            this.populateCard(builder, content);
            return Option.some((Object)builder.build());
        }
        catch (MalformedURLException e) {
            return Option.none();
        }
    }

    private Card.Builder populateCard(Card.Builder builder, AbstractPage content) throws MalformedURLException {
        builder.setTitle(content.getTitle());
        Space space = content.getSpace();
        String logoPath = this.spaceLogoManager.getLogoDownloadPath(space, (User)content.getCreator());
        builder.setIcon(LinkHelper.absoluteUrl(logoPath, this.applicationProperties));
        String spaceLabel = this.notificationMessageBuilder.getLabel("hipchat.activity.label.space");
        Card.Value.Builder spaceValue = Card.Value.builder();
        spaceValue.setLabel(space.getName());
        spaceValue.setUrl(LinkHelper.absoluteUrl(space.getUrlPath(), this.applicationProperties));
        builder.addAttribute(spaceLabel, spaceValue.build());
        String createdByLabel = this.notificationMessageBuilder.getLabel("hipchat.activity.label.creator");
        ConfluenceUser creator = content.getCreator();
        String createName = creator == null ? this.notificationMessageBuilder.getLabel("hipchat.notification.anonymous") : creator.getFullName();
        builder.addAttribute(createdByLabel, createName);
        return builder;
    }
}

