/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomConfig;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomConfigManager;
import com.google.common.collect.ImmutableList;
import net.java.ao.DBParam;

@Internal
public class DefaultEntityToRoomConfigManager
implements EntityToRoomConfigManager {
    private final ActiveObjects ao;

    public DefaultEntityToRoomConfigManager(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public Iterable<AOEntityToRoomConfig> getAll() {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomConfig.class));
    }

    @Override
    public Iterable<AOEntityToRoomConfig> getForRoom(String roomId) {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomConfig.class, "ROOM_ID = ?", new Object[]{roomId}));
    }

    @Override
    public Iterable<AOEntityToRoomConfig> getForEntity(String entityKey) {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomConfig.class, "ENTITY_KEY = ?", new Object[]{entityKey}));
    }

    @Override
    public Iterable<AOEntityToRoomConfig> getForEntityAndRoom(String entityKey, String roomId) {
        return ImmutableList.copyOf((Object[])this.ao.find(AOEntityToRoomConfig.class, "ENTITY_KEY = ? AND ROOM_ID = ?", new Object[]{entityKey, roomId}));
    }

    @Override
    public boolean hasConfigurationForRoom(String roomId) {
        return this.ao.count(AOEntityToRoomConfig.class, "ROOM_ID = ?", new Object[]{roomId}) > 0;
    }

    @Override
    public boolean hasConfigurationForEntity(String entityKey) {
        return this.ao.count(AOEntityToRoomConfig.class, "ENTITY_KEY = ?", new Object[]{entityKey}) > 0;
    }

    @Override
    public int removeConfigurationForEntity(String entityKey) {
        return this.ao.deleteWithSQL(AOEntityToRoomConfig.class, "ENTITY_KEY = ?", new Object[]{entityKey});
    }

    @Override
    public void removeConfigurationForEntityAndRoom(String entityKey, String roomId) {
        this.ao.deleteWithSQL(AOEntityToRoomConfig.class, "ENTITY_KEY = ? AND ROOM_ID = ?", new Object[]{entityKey, roomId});
    }

    @Override
    public void setNotifyClient(String entityKey, String roomId, boolean notifyClient) {
        AOEntityToRoomConfig entityToRoomMapping;
        AOEntityToRoomConfig[] existing = (AOEntityToRoomConfig[])this.ao.find(AOEntityToRoomConfig.class, "ENTITY_KEY = ? AND ROOM_ID = ?", new Object[]{entityKey, roomId});
        if (existing.length > 0) {
            entityToRoomMapping = existing[0];
        } else {
            entityToRoomMapping = (AOEntityToRoomConfig)this.ao.create(AOEntityToRoomConfig.class, new DBParam[0]);
            entityToRoomMapping.setEntityKey(entityKey);
            entityToRoomMapping.setRoomId(roomId);
        }
        entityToRoomMapping.setNotifyClient(notifyClient);
        entityToRoomMapping.save();
    }
}

