// Rivets.js
// version: 0.6.9
// author: Michael Richards
// license: MIT

// ATLASSIAN MODIFIED

(function() {
    var Rivets, bindMethod, unbindMethod, _ref,
        __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },
        __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
        __slice = [].slice,
        __hasProp = {}.hasOwnProperty,
        __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

    Rivets = {
        binders: {},
        components: {},
        formatters: {},
        adapters: {},
        config: {
            prefix: 'rv',
            templateDelimiters: ['{', '}'],
            rootInterface: '.',
            preloadData: true,
            handler: function(context, ev, binding) {
                return this.call(context, ev, binding.view.models);
            }
        }
    };

    if ('jQuery' in window) {
        _ref = 'on' in jQuery.prototype ? ['on', 'off'] : ['bind', 'unbind'], bindMethod = _ref[0], unbindMethod = _ref[1];
        Rivets.Util = {
            bindEvent: function(el, event, handler) {
                return jQuery(el)[bindMethod](event, handler);
            },
            unbindEvent: function(el, event, handler) {
                return jQuery(el)[unbindMethod](event, handler);
            },
            getInputValue: function(el) {
                var $el;
                $el = jQuery(el);
                if ($el.attr('type') === 'checkbox') {
                    return $el.is(':checked');
                } else {
                    return $el.val();
                }
            }
        };
    } else {
        Rivets.Util = {
            bindEvent: (function() {
                if ('addEventListener' in window) {
                    return function(el, event, handler) {
                        return el.addEventListener(event, handler, false);
                    };
                }
                return function(el, event, handler) {
                    return el.attachEvent('on' + event, handler);
                };
            })(),
            unbindEvent: (function() {
                if ('removeEventListener' in window) {
                    return function(el, event, handler) {
                        return el.removeEventListener(event, handler, false);
                    };
                }
                return function(el, event, handler) {
                    return el.detachEvent('on' + event, handler);
                };
            })(),
            getInputValue: function(el) {
                var o, _i, _len, _results;
                if (el.type === 'checkbox') {
                    return el.checked;
                } else if (el.type === 'select-multiple') {
                    _results = [];
                    for (_i = 0, _len = el.length; _i < _len; _i++) {
                        o = el[_i];
                        if (o.selected) {
                            _results.push(o.value);
                        }
                    }
                    return _results;
                } else {
                    return el.value;
                }
            }
        };
    }

    Rivets.KeypathParser = (function() {
        function KeypathParser() {}

        KeypathParser.parse = function(keypath, interfaces, root) {
            var c, current, index, tokens, _i, _ref1;
            tokens = [];
            current = {
                "interface": root,
                path: ''
            };
            for (index = _i = 0, _ref1 = keypath.length; _i < _ref1; index = _i += 1) {
                c = keypath.charAt(index);
                if (__indexOf.call(interfaces, c) >= 0) {
                    tokens.push(current);
                    current = {
                        "interface": c,
                        path: ''
                    };
                } else {
                    current.path += c;
                }
            }
            tokens.push(current);
            return tokens;
        };

        return KeypathParser;

    })();

    Rivets.TextTemplateParser = (function() {
        function TextTemplateParser() {}

        TextTemplateParser.types = {
            text: 0,
            binding: 1
        };

        TextTemplateParser.parse = function(template, delimiters) {
            var index, lastIndex, lastToken, length, substring, tokens, value;
            tokens = [];
            length = template.length;
            index = 0;
            lastIndex = 0;
            while (lastIndex < length) {
                index = template.indexOf(delimiters[0], lastIndex);
                if (index < 0) {
                    tokens.push({
                        type: this.types.text,
                        value: template.slice(lastIndex)
                    });
                    break;
                } else {
                    if (index > 0 && lastIndex < index) {
                        tokens.push({
                            type: this.types.text,
                            value: template.slice(lastIndex, index)
                        });
                    }
                    lastIndex = index + delimiters[0].length;
                    index = template.indexOf(delimiters[1], lastIndex);
                    if (index < 0) {
                        substring = template.slice(lastIndex - delimiters[1].length);
                        lastToken = tokens[tokens.length - 1];
                        if ((lastToken != null ? lastToken.type : void 0) === this.types.text) {
                            lastToken.value += substring;
                        } else {
                            tokens.push({
                                type: this.types.text,
                                value: substring
                            });
                        }
                        break;
                    }
                    value = template.slice(lastIndex, index).trim();
                    tokens.push({
                        type: this.types.binding,
                        value: value
                    });
                    lastIndex = index + delimiters[1].length;
                }
            }
            return tokens;
        };

        return TextTemplateParser;

    })();

    Rivets.Observer = (function() {
        function Observer(view, model, keypath, callback) {
            this.view = view;
            this.model = model;
            this.keypath = keypath;
            this.callback = callback;
            this.unobserve = __bind(this.unobserve, this);
            this.realize = __bind(this.realize, this);
            this.value = __bind(this.value, this);
            this.publish = __bind(this.publish, this);
            this.read = __bind(this.read, this);
            this.set = __bind(this.set, this);
            this.adapter = __bind(this.adapter, this);
            this.update = __bind(this.update, this);
            this.initialize = __bind(this.initialize, this);
            this.parse = __bind(this.parse, this);
            this.parse();
            this.initialize();
        }

        Observer.prototype.parse = function() {
            var interfaces, k, path, root, v, _ref1;
            interfaces = (function() {
                var _ref1, _results;
                _ref1 = this.view.adapters;
                _results = [];
                for (k in _ref1) {
                    v = _ref1[k];
                    if (v) {
                        _results.push(k);
                    }
                }
                return _results;
            }).call(this);
            if (_ref1 = this.keypath[0], __indexOf.call(interfaces, _ref1) >= 0) {
                root = this.keypath[0];
                path = this.keypath.substr(1);
            } else {
                root = this.view.config.rootInterface;
                path = this.keypath;
            }
            this.tokens = Rivets.KeypathParser.parse(path, interfaces, root);
            return this.key = this.tokens.pop();
        };

        Observer.prototype.initialize = function() {
            this.objectPath = [];
            this.target = this.realize();
            if (this.target != null) {
                return this.set(true, this.key, this.target, this.callback);
            }
        };

        Observer.prototype.update = function() {
            var next, oldValue;
            if ((next = this.realize()) !== this.target) {
                if (this.target != null) {
                    this.set(false, this.key, this.target, this.callback);
                }
                if (next != null) {
                    this.set(true, this.key, next, this.callback);
                }
                oldValue = this.value();
                this.target = next;
                if (this.value() !== oldValue) {
                    return this.callback();
                }
            }
        };

        Observer.prototype.adapter = function(key) {
            return this.view.adapters[key["interface"]];
        };

        Observer.prototype.set = function(active, key, obj, callback) {
            var action;
            action = active ? 'subscribe' : 'unsubscribe';
            return this.adapter(key)[action](obj, key.path, callback);
        };

        Observer.prototype.read = function(key, obj) {
            return this.adapter(key).read(obj, key.path);
        };

        Observer.prototype.publish = function(value) {
            if (this.target != null) {
                return this.adapter(this.key).publish(this.target, this.key.path, value);
            }
        };

        Observer.prototype.value = function() {
            if (this.target != null) {
                return this.read(this.key, this.target);
            }
        };

        Observer.prototype.realize = function() {
            var current, index, prev, token, unreached, _i, _len, _ref1;
            current = this.model;
            unreached = null;
            _ref1 = this.tokens;
            for (index = _i = 0, _len = _ref1.length; _i < _len; index = ++_i) {
                token = _ref1[index];
                if (current != null) {
                    if (this.objectPath[index] != null) {
                        if (current !== (prev = this.objectPath[index])) {
                            this.set(false, token, prev, this.update);
                            this.set(true, token, current, this.update);
                            this.objectPath[index] = current;
                        }
                    } else {
                        this.set(true, token, current, this.update);
                        this.objectPath[index] = current;
                    }
                    current = this.read(token, current);
                } else {
                    if (unreached == null) {
                        unreached = index;
                    }
                    if (prev = this.objectPath[index]) {
                        this.set(false, token, prev, this.update);
                    }
                }
            }
            if (unreached != null) {
                this.objectPath.splice(unreached);
            }
            return current;
        };

        Observer.prototype.unobserve = function() {
            var index, obj, token, _i, _len, _ref1;
            _ref1 = this.tokens;
            for (index = _i = 0, _len = _ref1.length; _i < _len; index = ++_i) {
                token = _ref1[index];
                if (obj = this.objectPath[index]) {
                    this.set(false, token, obj, this.update);
                }
            }
            if (this.target != null) {
                return this.set(false, this.key, this.target, this.callback);
            }
        };

        return Observer;

    })();

    Rivets.View = (function() {
        function View(els, models, options) {
            var k, option, v, _base, _i, _len, _ref1, _ref2, _ref3;
            this.els = els;
            this.models = models;
            this.options = options != null ? options : {};
            this.update = __bind(this.update, this);
            this.publish = __bind(this.publish, this);
            this.sync = __bind(this.sync, this);
            this.unbind = __bind(this.unbind, this);
            this.bind = __bind(this.bind, this);
            this.select = __bind(this.select, this);
            this.build = __bind(this.build, this);
            this.componentRegExp = __bind(this.componentRegExp, this);
            this.bindingRegExp = __bind(this.bindingRegExp, this);
            if (!(this.els.jquery || this.els instanceof Array)) {
                this.els = [this.els];
            }
            _ref1 = ['config', 'binders', 'formatters', 'adapters'];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                option = _ref1[_i];
                this[option] = {};
                if (this.options[option]) {
                    _ref2 = this.options[option];
                    for (k in _ref2) {
                        v = _ref2[k];
                        this[option][k] = v;
                    }
                }
                _ref3 = Rivets[option];
                for (k in _ref3) {
                    v = _ref3[k];
                    if ((_base = this[option])[k] == null) {
                        _base[k] = v;
                    }
                }
            }
            this.build();
        }

        View.prototype.bindingRegExp = function() {
            return new RegExp("^" + this.config.prefix + "-");
        };

        View.prototype.componentRegExp = function() {
            return new RegExp("^" + (this.config.prefix.toUpperCase()) + "-");
        };

        View.prototype.build = function() {
            var bindingRegExp, buildBinding, componentRegExp, el, parse, skipNodes, _i, _len, _ref1;
            this.bindings = [];
            skipNodes = [];
            bindingRegExp = this.bindingRegExp();
            componentRegExp = this.componentRegExp();
            buildBinding = (function(_this) {
                return function(binding, node, type, declaration) {
                    var context, ctx, dependencies, keypath, options, pipe, pipes;
                    options = {};
                    pipes = (function() {
                        var _i, _len, _ref1, _results;
                        _ref1 = declaration.split('|');
                        _results = [];
                        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                            pipe = _ref1[_i];
                            _results.push(pipe.trim());
                        }
                        return _results;
                    })();
                    context = (function() {
                        var _i, _len, _ref1, _results;
                        _ref1 = pipes.shift().split('<');
                        _results = [];
                        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                            ctx = _ref1[_i];
                            _results.push(ctx.trim());
                        }
                        return _results;
                    })();
                    keypath = context.shift();
                    options.formatters = pipes;
                    if (dependencies = context.shift()) {
                        options.dependencies = dependencies.split(/\s+/);
                    }
                    return _this.bindings.push(new Rivets[binding](_this, node, type, keypath, options));
                };
            })(this);
            parse = (function(_this) {
                return function(node) {
                    var attribute, attributes, binder, childNode, delimiters, identifier, n, parser, regexp, text, token, tokens, type, value, _i, _j, _k, _l, _len, _len1, _len2, _len3, _len4, _m, _ref1, _ref2, _ref3, _ref4, _ref5, _results;
                    if (__indexOf.call(skipNodes, node) < 0) {
                        if (node.nodeType === 3) {
                            parser = Rivets.TextTemplateParser;
                            if (delimiters = _this.config.templateDelimiters) {
                                if ((tokens = parser.parse(node.data, delimiters)).length) {
                                    if (!(tokens.length === 1 && tokens[0].type === parser.types.text)) {
                                        for (_i = 0, _len = tokens.length; _i < _len; _i++) {
                                            token = tokens[_i];
                                            text = document.createTextNode(token.value);
                                            node.parentNode.insertBefore(text, node);
                                            if (token.type === 1) {
                                                buildBinding('TextBinding', text, null, token.value);
                                            }
                                        }
                                        node.parentNode.removeChild(node);
                                    }
                                }
                            }
                        } else if (componentRegExp.test(node.tagName)) {
                            type = node.tagName.replace(componentRegExp, '').toLowerCase();
                            _this.bindings.push(new Rivets.ComponentBinding(_this, node, type));
                        } else if (node.attributes != null) {
                            _ref1 = node.attributes;
                            for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
                                attribute = _ref1[_j];
                                if (bindingRegExp.test(attribute.name)) {
                                    type = attribute.name.replace(bindingRegExp, '');
                                    if (!(binder = _this.binders[type])) {
                                        _ref2 = _this.binders;
                                        for (identifier in _ref2) {
                                            value = _ref2[identifier];
                                            if (identifier !== '*' && identifier.indexOf('*') !== -1) {
                                                regexp = new RegExp("^" + (identifier.replace('*', '.+')) + "$");
                                                if (regexp.test(type)) {
                                                    binder = value;
                                                }
                                            }
                                        }
                                    }
                                    binder || (binder = _this.binders['*']);
                                    if (binder.block) {
                                        _ref3 = node.childNodes;
                                        for (_k = 0, _len2 = _ref3.length; _k < _len2; _k++) {
                                            n = _ref3[_k];
                                            skipNodes.push(n);
                                        }
                                        attributes = [attribute];
                                    }
                                }
                            }
                            _ref4 = attributes || node.attributes;
                            for (_l = 0, _len3 = _ref4.length; _l < _len3; _l++) {
                                attribute = _ref4[_l];
                                if (bindingRegExp.test(attribute.name)) {
                                    type = attribute.name.replace(bindingRegExp, '');
                                    buildBinding('Binding', node, type, attribute.value);
                                }
                            }
                        }
                        _ref5 = (function() {
                            var _len4, _n, _ref5, _results1;
                            _ref5 = node.childNodes;
                            _results1 = [];
                            for (_n = 0, _len4 = _ref5.length; _n < _len4; _n++) {
                                n = _ref5[_n];
                                _results1.push(n);
                            }
                            return _results1;
                        })();
                        _results = [];
                        for (_m = 0, _len4 = _ref5.length; _m < _len4; _m++) {
                            childNode = _ref5[_m];
                            _results.push(parse(childNode));
                        }
                        return _results;
                    }
                };
            })(this);
            _ref1 = this.els;
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                el = _ref1[_i];
                parse(el);
            }
        };

        View.prototype.select = function(fn) {
            var binding, _i, _len, _ref1, _results;
            _ref1 = this.bindings;
            _results = [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                binding = _ref1[_i];
                if (fn(binding)) {
                    _results.push(binding);
                }
            }
            return _results;
        };

        View.prototype.bind = function() {
            var binding, _i, _len, _ref1, _results;
            _ref1 = this.bindings;
            _results = [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                binding = _ref1[_i];
                _results.push(binding.bind());
            }
            return _results;
        };

        View.prototype.unbind = function() {
            var binding, _i, _len, _ref1, _results;
            _ref1 = this.bindings;
            _results = [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                binding = _ref1[_i];
                _results.push(binding.unbind());
            }
            return _results;
        };

        View.prototype.sync = function() {
            var binding, _i, _len, _ref1, _results;
            _ref1 = this.bindings;
            _results = [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                binding = _ref1[_i];
                _results.push(binding.sync());
            }
            return _results;
        };

        View.prototype.publish = function() {
            var binding, _i, _len, _ref1, _results;
            _ref1 = this.select(function(b) {
                return b.binder.publishes;
            });
            _results = [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                binding = _ref1[_i];
                _results.push(binding.publish());
            }
            return _results;
        };

        View.prototype.update = function(models) {
            var binding, key, model, _i, _len, _ref1, _results;
            if (models == null) {
                models = {};
            }
            for (key in models) {
                model = models[key];
                this.models[key] = model;
            }
            _ref1 = this.bindings;
            _results = [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                binding = _ref1[_i];
                _results.push(binding.update(models));
            }
            return _results;
        };

        return View;

    })();

    Rivets.Binding = (function() {
        function Binding(view, el, type, keypath, options) {
            this.view = view;
            this.el = el;
            this.type = type;
            this.keypath = keypath;
            this.options = options != null ? options : {};
            this.update = __bind(this.update, this);
            this.unbind = __bind(this.unbind, this);
            this.bind = __bind(this.bind, this);
            this.publish = __bind(this.publish, this);
            this.sync = __bind(this.sync, this);
            this.set = __bind(this.set, this);
            this.eventHandler = __bind(this.eventHandler, this);
            this.formattedValue = __bind(this.formattedValue, this);
            this.setBinder = __bind(this.setBinder, this);
            this.formatters = this.options.formatters || [];
            this.dependencies = [];
            this.model = void 0;
            this.setBinder();
        }

        Binding.prototype.setBinder = function() {
            var identifier, regexp, value, _ref1;
            if (!(this.binder = this.view.binders[this.type])) {
                _ref1 = this.view.binders;
                for (identifier in _ref1) {
                    value = _ref1[identifier];
                    if (identifier !== '*' && identifier.indexOf('*') !== -1) {
                        regexp = new RegExp("^" + (identifier.replace('*', '.+')) + "$");
                        if (regexp.test(this.type)) {
                            this.binder = value;
                            this.args = new RegExp("^" + (identifier.replace('*', '(.+)')) + "$").exec(this.type);
                            this.args.shift();
                        }
                    }
                }
            }
            this.binder || (this.binder = this.view.binders['*']);
            if (this.binder instanceof Function) {
                return this.binder = {
                    routine: this.binder
                };
            }
        };

        Binding.prototype.formattedValue = function(value) {
            var args, formatter, id, _i, _len, _ref1;
            _ref1 = this.formatters;
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                formatter = _ref1[_i];
                args = formatter.split(/\s+/);
                id = args.shift();
                formatter = this.view.formatters[id];
                if ((formatter != null ? formatter.read : void 0) instanceof Function) {
                    value = formatter.read.apply(formatter, [value].concat(__slice.call(args)));
                } else if (formatter instanceof Function) {
                    value = formatter.apply(null, [value].concat(__slice.call(args)));
                }
            }
            return value;
        };

        Binding.prototype.eventHandler = function(fn) {
            var binding, handler;
            handler = (binding = this).view.config.handler;
            return function(ev) {
                return handler.call(fn, this, ev, binding);
            };
        };

        Binding.prototype.set = function(value) {
            var _ref1;
            value = value instanceof Function && !this.binder["function"] ? this.formattedValue(value.call(this.model)) : this.formattedValue(value);
            return (_ref1 = this.binder.routine) != null ? _ref1.call(this, this.el, value) : void 0;
        };

        Binding.prototype.sync = function() {
            var dependency, observer, _i, _j, _len, _len1, _ref1, _ref2, _ref3;
            if (this.model !== this.observer.target) {
                _ref1 = this.dependencies;
                for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                    observer = _ref1[_i];
                    observer.unobserve();
                }
                this.dependencies = [];
                if (((this.model = this.observer.target) != null) && ((_ref2 = this.options.dependencies) != null ? _ref2.length : void 0)) {
                    _ref3 = this.options.dependencies;
                    for (_j = 0, _len1 = _ref3.length; _j < _len1; _j++) {
                        dependency = _ref3[_j];
                        observer = new Rivets.Observer(this.view, this.model, dependency, this.sync);
                        this.dependencies.push(observer);
                    }
                }
            }
            return this.set(this.observer.value());
        };

        Binding.prototype.publish = function() {
            var args, formatter, id, value, _i, _len, _ref1, _ref2, _ref3;
            value = Rivets.Util.getInputValue(this.el);
            _ref1 = this.formatters.slice(0).reverse();
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                formatter = _ref1[_i];
                args = formatter.split(/\s+/);
                id = args.shift();
                if ((_ref2 = this.view.formatters[id]) != null ? _ref2.publish : void 0) {
                    value = (_ref3 = this.view.formatters[id]).publish.apply(_ref3, [value].concat(__slice.call(args)));
                }
            }
            return this.observer.publish(value);
        };

        Binding.prototype.bind = function() {
            var dependency, observer, _i, _len, _ref1, _ref2, _ref3;
            if ((_ref1 = this.binder.bind) != null) {
                _ref1.call(this, this.el);
            }
            this.observer = new Rivets.Observer(this.view, this.view.models, this.keypath, this.sync);
            this.model = this.observer.target;
            if ((this.model != null) && ((_ref2 = this.options.dependencies) != null ? _ref2.length : void 0)) {
                _ref3 = this.options.dependencies;
                for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                    dependency = _ref3[_i];
                    observer = new Rivets.Observer(this.view, this.model, dependency, this.sync);
                    this.dependencies.push(observer);
                }
            }
            if (this.view.config.preloadData) {
                return this.sync();
            }
        };

        Binding.prototype.unbind = function() {
            var observer, _i, _len, _ref1, _ref2;
            if ((_ref1 = this.binder.unbind) != null) {
                _ref1.call(this, this.el);
            }
            this.observer.unobserve();
            _ref2 = this.dependencies;
            for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
                observer = _ref2[_i];
                observer.unobserve();
            }
            return this.dependencies = [];
        };

        Binding.prototype.update = function(models) {
            var _ref1;
            if (models == null) {
                models = {};
            }
            this.model = this.observer.target;
            this.unbind();
            if ((_ref1 = this.binder.update) != null) {
                _ref1.call(this, models);
            }
            return this.bind();
        };

        return Binding;

    })();

    Rivets.ComponentBinding = (function(_super) {
        __extends(ComponentBinding, _super);

        function ComponentBinding(view, el, type) {
            var attribute, _i, _len, _ref1, _ref2;
            this.view = view;
            this.el = el;
            this.type = type;
            this.unbind = __bind(this.unbind, this);
            this.bind = __bind(this.bind, this);
            this.update = __bind(this.update, this);
            this.locals = __bind(this.locals, this);
            this.component = Rivets.components[this.type];
            this.attributes = {};
            this.inflections = {};
            _ref1 = this.el.attributes || [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                attribute = _ref1[_i];
                if (_ref2 = attribute.name, __indexOf.call(this.component.attributes, _ref2) >= 0) {
                    this.attributes[attribute.name] = attribute.value;
                } else {
                    this.inflections[attribute.name] = attribute.value;
                }
            }
        }

        ComponentBinding.prototype.sync = function() {};

        ComponentBinding.prototype.locals = function(models) {
            var inverse, key, model, path, result, _i, _len, _ref1, _ref2;
            if (models == null) {
                models = this.view.models;
            }
            result = {};
            _ref1 = this.inflections;
            for (key in _ref1) {
                inverse = _ref1[key];
                _ref2 = inverse.split('.');
                for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
                    path = _ref2[_i];
                    result[key] = (result[key] || models)[path];
                }
            }
            for (key in models) {
                model = models[key];
                if (result[key] == null) {
                    result[key] = model;
                }
            }
            return result;
        };

        ComponentBinding.prototype.update = function(models) {
            var _ref1;
            return (_ref1 = this.componentView) != null ? _ref1.update(this.locals(models)) : void 0;
        };

        ComponentBinding.prototype.bind = function() {
            var el, _ref1;
            if (this.componentView != null) {
                return (_ref1 = this.componentView) != null ? _ref1.bind() : void 0;
            } else {
                el = this.component.build.call(this.attributes);
                (this.componentView = new Rivets.View(el, this.locals(), this.view.options)).bind();
                return this.el.parentNode.replaceChild(el, this.el);
            }
        };

        ComponentBinding.prototype.unbind = function() {
            var _ref1;
            return (_ref1 = this.componentView) != null ? _ref1.unbind() : void 0;
        };

        return ComponentBinding;

    })(Rivets.Binding);

    Rivets.TextBinding = (function(_super) {
        __extends(TextBinding, _super);

        function TextBinding(view, el, type, keypath, options) {
            this.view = view;
            this.el = el;
            this.type = type;
            this.keypath = keypath;
            this.options = options != null ? options : {};
            this.sync = __bind(this.sync, this);
            this.formatters = this.options.formatters || [];
            this.dependencies = [];
        }

        TextBinding.prototype.binder = {
            routine: function(node, value) {
                return node.data = value != null ? value : '';
            }
        };

        TextBinding.prototype.sync = function() {
            return TextBinding.__super__.sync.apply(this, arguments);
        };

        return TextBinding;

    })(Rivets.Binding);

    Rivets.adapters['.'] = {
        id: '_rv',
        counter: 0,
        weakmap: {},
        weakReference: function(obj) {
            var id;
            if (!obj.hasOwnProperty(this.id)) {
                id = this.counter++;
                this.weakmap[id] = {
                    callbacks: {}
                };
                Object.defineProperty(obj, this.id, {
                    value: id
                });
            }
            return this.weakmap[obj[this.id]];
        },
        stubFunction: function(obj, fn) {
            var map, original, weakmap;
            original = obj[fn];
            map = this.weakReference(obj);
            weakmap = this.weakmap;
            return obj[fn] = function() {
                var callback, k, r, response, _i, _len, _ref1, _ref2, _ref3, _ref4;
                response = original.apply(obj, arguments);
                _ref1 = map.pointers;
                for (r in _ref1) {
                    k = _ref1[r];
                    _ref4 = (_ref2 = (_ref3 = weakmap[r]) != null ? _ref3.callbacks[k] : void 0) != null ? _ref2 : [];
                    for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
                        callback = _ref4[_i];
                        callback();
                    }
                }
                return response;
            };
        },
        observeMutations: function(obj, ref, keypath) {
            var fn, functions, map, _base, _i, _len;
            if (Array.isArray(obj)) {
                map = this.weakReference(obj);
                if (map.pointers == null) {
                    map.pointers = {};
                    functions = ['push', 'pop', 'shift', 'unshift', 'sort', 'reverse', 'splice'];
                    for (_i = 0, _len = functions.length; _i < _len; _i++) {
                        fn = functions[_i];
                        this.stubFunction(obj, fn);
                    }
                }
                if ((_base = map.pointers)[ref] == null) {
                    _base[ref] = [];
                }
                if (__indexOf.call(map.pointers[ref], keypath) < 0) {
                    return map.pointers[ref].push(keypath);
                }
            }
        },
        unobserveMutations: function(obj, ref, keypath) {
            var idx, keypaths, _ref1;
            if (Array.isArray(obj && (obj[this.id] != null))) {
                if (keypaths = (_ref1 = this.weakReference(obj).pointers) != null ? _ref1[ref] : void 0) {
                    idx = keypaths.indexOf(keypath);
                    if (idx >= 0) {
                        return keypaths.splice(idx, 1);
                    }
                }
            }
        },
        subscribe: function(obj, keypath, callback) {
            var callbacks, value;
            callbacks = this.weakReference(obj).callbacks;
            if (callbacks[keypath] == null) {
                callbacks[keypath] = [];
                value = obj[keypath];
                Object.defineProperty(obj, keypath, {
                    enumerable: true,
                    get: function() {
                        return value;
                    },
                    set: (function(_this) {
                        return function(newValue) {
                            var _i, _len, _ref1;
                            if (newValue !== value) {
                                value = newValue;
                                _ref1 = callbacks[keypath].slice();
                                for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                                    callback = _ref1[_i];
                                    if (__indexOf.call(callbacks[keypath], callback) >= 0) {
                                        callback();
                                    }
                                }
                                return _this.observeMutations(newValue, obj[_this.id], keypath);
                            }
                        };
                    })(this)
                });
            }
            if (__indexOf.call(callbacks[keypath], callback) < 0) {
                callbacks[keypath].push(callback);
            }
            return this.observeMutations(obj[keypath], obj[this.id], keypath);
        },
        unsubscribe: function(obj, keypath, callback) {
            var callbacks, idx;
            callbacks = this.weakmap[obj[this.id]].callbacks[keypath];
            idx = callbacks.indexOf(callback);
            if (idx >= 0) {
                callbacks.splice(idx, 1);
            }
            return this.unobserveMutations(obj[keypath], obj[this.id], keypath);
        },
        read: function(obj, keypath) {
            return obj[keypath];
        },
        publish: function(obj, keypath, value) {
            return obj[keypath] = value;
        }
    };

    Rivets.binders.text = function(el, value) {
        if (el.textContent != null) {
            return el.textContent = value != null ? value : '';
        } else {
            return el.innerText = value != null ? value : '';
        }
    };

    Rivets.binders.html = function(el, value) {
        return el.innerHTML = value != null ? value : '';
    };

    Rivets.binders.show = function(el, value) {
        return el.style.display = value ? '' : 'none';
    };

    Rivets.binders.hide = function(el, value) {
        return el.style.display = value ? 'none' : '';
    };

    Rivets.binders.enabled = function(el, value) {
        return el.disabled = !value;
    };

    Rivets.binders.disabled = function(el, value) {
        return el.disabled = !!value;
    };

    Rivets.binders.checked = {
        publishes: true,
        bind: function(el) {
            return Rivets.Util.bindEvent(el, 'change', this.publish);
        },
        unbind: function(el) {
            return Rivets.Util.unbindEvent(el, 'change', this.publish);
        },
        routine: function(el, value) {
            var _ref1;
            if (el.type === 'radio') {
                return el.checked = ((_ref1 = el.value) != null ? _ref1.toString() : void 0) === (value != null ? value.toString() : void 0);
            } else {
                return el.checked = !!value;
            }
        }
    };

    Rivets.binders.unchecked = {
        publishes: true,
        bind: function(el) {
            return Rivets.Util.bindEvent(el, 'change', this.publish);
        },
        unbind: function(el) {
            return Rivets.Util.unbindEvent(el, 'change', this.publish);
        },
        routine: function(el, value) {
            var _ref1;
            if (el.type === 'radio') {
                return el.checked = ((_ref1 = el.value) != null ? _ref1.toString() : void 0) !== (value != null ? value.toString() : void 0);
            } else {
                return el.checked = !value;
            }
        }
    };

    Rivets.binders.value = {
        publishes: true,
        bind: function(el) {
            return Rivets.Util.bindEvent(el, 'change', this.publish);
        },
        unbind: function(el) {
            return Rivets.Util.unbindEvent(el, 'change', this.publish);
        },
        routine: function(el, value) {
            var o, _i, _len, _ref1, _ref2, _ref3, _results;
            if (window.jQuery != null) {
                el = jQuery(el);
                if ((value != null ? value.toString() : void 0) !== ((_ref1 = el.val()) != null ? _ref1.toString() : void 0)) {
                    return el.val(value != null ? value : '');
                }
            } else {
                if (el.type === 'select-multiple') {
                    if (value != null) {
                        _results = [];
                        for (_i = 0, _len = el.length; _i < _len; _i++) {
                            o = el[_i];
                            _results.push(o.selected = (_ref2 = o.value, __indexOf.call(value, _ref2) >= 0));
                        }
                        return _results;
                    }
                } else if ((value != null ? value.toString() : void 0) !== ((_ref3 = el.value) != null ? _ref3.toString() : void 0)) {
                    return el.value = value != null ? value : '';
                }
            }
        }
    };

    Rivets.binders["if"] = {
        block: true,
        bind: function(el) {
            var attr, declaration;
            if (this.marker == null) {
                attr = [this.view.config.prefix, this.type].join('-').replace('--', '-');
                declaration = el.getAttribute(attr);
                this.marker = document.createComment(" rivets: " + this.type + " " + declaration + " ");
                el.removeAttribute(attr);
                el.parentNode.insertBefore(this.marker, el);
                return el.parentNode.removeChild(el);
            }
        },
        unbind: function() {
            var _ref1;
            return (_ref1 = this.nested) != null ? _ref1.unbind() : void 0;
        },
        routine: function(el, value) {
            var key, model, models, options, _ref1;
            if (!!value === (this.nested == null)) {
                if (value) {
                    models = {};
                    _ref1 = this.view.models;
                    for (key in _ref1) {
                        model = _ref1[key];
                        models[key] = model;
                    }
                    options = {
                        binders: this.view.options.binders,
                        formatters: this.view.options.formatters,
                        adapters: this.view.options.adapters,
                        config: this.view.options.config
                    };
                    (this.nested = new Rivets.View(el, models, options)).bind();
                    return this.marker.parentNode.insertBefore(el, this.marker.nextSibling);
                } else {
                    el.parentNode.removeChild(el);
                    this.nested.unbind();
                    return delete this.nested;
                }
            }
        },
        update: function(models) {
            var _ref1;
            return (_ref1 = this.nested) != null ? _ref1.update(models) : void 0;
        }
    };

    Rivets.binders.unless = {
        block: true,
        bind: function(el) {
            return Rivets.binders["if"].bind.call(this, el);
        },
        unbind: function() {
            return Rivets.binders["if"].unbind.call(this);
        },
        routine: function(el, value) {
            return Rivets.binders["if"].routine.call(this, el, !value);
        },
        update: function(models) {
            return Rivets.binders["if"].update.call(this, models);
        }
    };

    Rivets.binders['on-*'] = {
        "function": true,
        unbind: function(el) {
            if (this.handler) {
                return Rivets.Util.unbindEvent(el, this.args[0], this.handler);
            }
        },
        routine: function(el, value) {
            if (this.handler) {
                Rivets.Util.unbindEvent(el, this.args[0], this.handler);
            }
            return Rivets.Util.bindEvent(el, this.args[0], this.handler = this.eventHandler(value));
        }
    };

    Rivets.binders['each-*'] = {
        block: true,
        bind: function(el) {
            var attr, view, _i, _len, _ref1;
            if (this.marker == null) {
                attr = [this.view.config.prefix, this.type].join('-').replace('--', '-');
                this.marker = document.createComment(" rivets: " + this.type + " ");
                this.iterated = [];
                el.removeAttribute(attr);
                el.parentNode.insertBefore(this.marker, el);
                el.parentNode.removeChild(el);
            } else {
                _ref1 = this.iterated;
                for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                    view = _ref1[_i];
                    view.bind();
                }
            }
        },
        unbind: function(el) {
            var view, _i, _len, _ref1, _results;
            if (this.iterated != null) {
                _ref1 = this.iterated;
                _results = [];
                for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                    view = _ref1[_i];
                    _results.push(view.unbind());
                }
                return _results;
            }
        },
        routine: function(el, collection) {
            var binding, data, i, index, k, key, model, modelName, options, previous, template, v, view, _i, _j, _k, _len, _len1, _len2, _ref1, _ref2, _ref3, _ref4, _results;
            modelName = this.args[0];
            collection = collection || [];
            if (this.iterated.length > collection.length) {
                _ref1 = Array(this.iterated.length - collection.length);
                for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                    i = _ref1[_i];
                    view = this.iterated.pop();
                    view.unbind();
                    this.marker.parentNode.removeChild(view.els[0]);
                }
            }
            for (index = _j = 0, _len1 = collection.length; _j < _len1; index = ++_j) {
                model = collection[index];
                data = {
                    index: index
                };
                data[modelName] = model;
                if (this.iterated[index] == null) {
                    _ref2 = this.view.models;
                    for (key in _ref2) {
                        model = _ref2[key];
                        if (data[key] == null) {
                            data[key] = model;
                        }
                    }
                    previous = this.iterated.length ? this.iterated[this.iterated.length - 1].els[0] : this.marker;
                    options = {
                        binders: this.view.options.binders,
                        formatters: this.view.options.formatters,
                        adapters: this.view.options.adapters,
                        config: {}
                    };
                    _ref3 = this.view.options.config;
                    for (k in _ref3) {
                        v = _ref3[k];
                        options.config[k] = v;
                    }
                    options.config.preloadData = true;
                    template = el.cloneNode(true);
                    view = new Rivets.View(template, data, options);
                    view.bind();
                    this.iterated.push(view);
                    this.marker.parentNode.insertBefore(template, previous.nextSibling);
                } else if (this.iterated[index].models[modelName] !== model) {
                    this.iterated[index].update(data);
                }
            }
            if (el.nodeName === 'OPTION') {
                _ref4 = this.view.bindings;
                _results = [];
                for (_k = 0, _len2 = _ref4.length; _k < _len2; _k++) {
                    binding = _ref4[_k];
                    if (binding.el === this.marker.parentNode && binding.type === 'value') {
                        _results.push(binding.sync());
                    } else {
                        _results.push(void 0);
                    }
                }
                return _results;
            }
        },
        update: function(models) {
            var data, key, model, view, _i, _len, _ref1, _results;
            data = {};
            for (key in models) {
                model = models[key];
                if (key !== this.args[0]) {
                    data[key] = model;
                }
            }
            _ref1 = this.iterated;
            _results = [];
            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                view = _ref1[_i];
                _results.push(view.update(data));
            }
            return _results;
        }
    };

    Rivets.binders['class-*'] = function(el, value) {
        var elClass;
        elClass = " " + el.className + " ";
        if (!value === (elClass.indexOf(" " + this.args[0] + " ") !== -1)) {
            return el.className = value ? "" + el.className + " " + this.args[0] : elClass.replace(" " + this.args[0] + " ", ' ').trim();
        }
    };

    Rivets.binders['*'] = function(el, value) {
        if (value != null) {
            return el.setAttribute(this.type, value);
        } else {
            return el.removeAttribute(this.type);
        }
    };

    Rivets.factory = function(exports) {
        exports._ = Rivets;
        exports.binders = Rivets.binders;
        exports.components = Rivets.components;
        exports.formatters = Rivets.formatters;
        exports.adapters = Rivets.adapters;
        exports.config = Rivets.config;
        exports.configure = function(options) {
            var property, value;
            if (options == null) {
                options = {};
            }
            for (property in options) {
                value = options[property];
                Rivets.config[property] = value;
            }
        };
        return exports.bind = function(el, models, options) {
            var view;
            if (models == null) {
                models = {};
            }
            if (options == null) {
                options = {};
            }
            view = new Rivets.View(el, models, options);
            view.bind();
            return view;
        };
    };

    // ATLASSIAN MODIFIED. Just export via AMD without usual define.amd safety checks.
    var exports = {};
    Rivets.factory(exports);
    define("rivets", exports);

    //if (typeof exports === 'object') {
    //    Rivets.factory(exports);
    //} else if (typeof define === 'function' && define.amd) {
    //    define(['exports'], function(exports) {
    //        Rivets.factory(this.rivets = exports);
    //        return exports;
    //    });
    //} else {
    //    Rivets.factory(this.rivets = {});
    //}

}).call(this);
