/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.emoticons.marshalling;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.Marshaller;
import com.atlassian.confluence.content.render.xhtml.MarshallingRegistry;
import com.atlassian.confluence.content.render.xhtml.MarshallingType;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlOutputFactory;
import com.atlassian.confluence.plugins.hipchat.emoticons.HipChatEmoticon;
import com.atlassian.confluence.plugins.hipchat.emoticons.marshalling.EmoticonEditorUnmarshaller;
import com.atlassian.confluence.plugins.hipchat.emoticons.service.HipChatEmoticonService;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.springframework.beans.factory.InitializingBean;

public class EmoticonEditorMarshaller
implements Marshaller<HipChatEmoticon>,
InitializingBean {
    private final XmlOutputFactory xmlOutputFactory;
    private final HipChatEmoticonService hipChatEmoticonService;
    private MarshallingRegistry marshallingRegistry;

    public EmoticonEditorMarshaller(XmlOutputFactory xmlOutputFactory, HipChatEmoticonService hipChatEmoticonService, MarshallingRegistry marshallingRegistry) {
        this.xmlOutputFactory = xmlOutputFactory;
        this.hipChatEmoticonService = hipChatEmoticonService;
        this.marshallingRegistry = marshallingRegistry;
    }

    public void afterPropertiesSet() {
        this.marshallingRegistry.register((Marshaller)this, HipChatEmoticon.class, MarshallingType.EDITOR);
        this.marshallingRegistry.register((Marshaller)this, HipChatEmoticon.class, MarshallingType.VIEW);
    }

    public Streamable marshal(final HipChatEmoticon hipChatEmoticon, ConversionContext conversionContext) throws XhtmlException {
        return new Streamable(){

            public void writeTo(Writer sink) throws IOException {
                try {
                    XMLStreamWriter writer = EmoticonEditorMarshaller.this.xmlOutputFactory.createXMLStreamWriter(sink);
                    String shortcut = hipChatEmoticon.getShortcut();
                    String title = "(" + shortcut + ")";
                    HipChatEmoticon emoticon = EmoticonEditorMarshaller.this.hipChatEmoticonService.findByShortcut(shortcut);
                    if (emoticon == null) {
                        writer.writeStartElement("span");
                        writer.writeAttribute(EmoticonEditorUnmarshaller.EMOTICON_ATTR_ID.getLocalPart(), shortcut);
                        writer.writeAttribute("title", title);
                        writer.writeAttribute("class", "unknown-hipchat-emoticon");
                        writer.writeCharacters(title);
                        writer.writeEndElement();
                        writer.close();
                        return;
                    }
                    writer.writeEmptyElement("img");
                    writer.writeAttribute("alt", title);
                    writer.writeAttribute("title", title);
                    writer.writeAttribute("border", "0");
                    writer.writeAttribute(EmoticonEditorUnmarshaller.EMOTICON_ATTR_ID.getLocalPart(), shortcut);
                    writer.writeAttribute("class", "emoticon emoticon-" + shortcut);
                    writer.writeAttribute("src", emoticon.getUrl());
                    writer.close();
                }
                catch (XMLStreamException e) {
                    throw new IOException("Error marshalling " + hipChatEmoticon + " to editor format", e);
                }
            }
        };
    }
}

