/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.highlight.xml;

import com.atlassian.confluence.plugins.highlight.model.TextCollection;
import com.atlassian.confluence.plugins.highlight.xml.ModificationStateTracker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextCollector {
    public TextCollection collect(Document document, ModificationStateTracker stateTracker) {
        return this.collectTextRecursively(document.getDocumentElement(), stateTracker, new TextCollection());
    }

    private TextCollection collectTextRecursively(Node node, ModificationStateTracker stateTracker, TextCollection textCollection) {
        if (node.getNodeType() == 1 && node.hasChildNodes()) {
            String tagName = ((Element)node).getTagName();
            stateTracker.forward(tagName);
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                this.collectTextRecursively(childNodes.item(i), stateTracker, textCollection);
            }
            stateTracker.back(tagName);
        }
        if (stateTracker.shouldProcessText(node)) {
            textCollection.add(node, stateTracker.allowInsertion());
        }
        return textCollection;
    }
}

