define('confluence/fh/handlers/page-view-handler', [
    'confluence/fh/utils/dom',
    'jquery',
    'ajs',
    'exports'
], function (dom, $, AJS, exports) {
    'use strict';

    var $header, $main, $mainHeader, $actionMenuLink, $mainHeaderPlaceholder, $fixedSideBar,
        mainHeaderCss, mainCss, headerTop, headerHeight, mainHeaderTop,
        isFixedHeader = false, isFixedMainHeader = false, isMainHeaderOverlay = false, scrollPosition = 0, movingDistance = 0, scrollUpTrackingDistance = 0,
        BUFFERED_DISTANCE = 50, MAIN_HEADER_Z_INDEX = 100,
        // Support for analytics
        HOVER = 'by-hover', SCROLL = 'by-scroll', OTHER = 'by-other', showMainHeaderBy = OTHER, isKeepDotDotDotButton = false;

    function initialize(force) {
        if (initialize.done && !force) {
            return;
        }

        $header = $('#header');

        // CONFDEV-35938: For backward compatibility for AUI sidebar conversion.
        $main = $('#main .aui-page-panel-outer-content');
        $main.length === 0 && ($main = $('#main'));

        $mainHeader = $('#main-header');
        $actionMenuLink = $('#action-menu-link');
        $mainHeaderPlaceholder = dom.createMainHeaderPlaceHolder();
        $fixedSideBar = $('.ia-splitter-left .ia-fixed-sidebar');

        mainHeaderCss = $mainHeader.prop('style');
        mainCss = $main.prop('style');
        headerTop = Math.round($header.offset().top);
        headerHeight = $header.height();
        mainHeaderTop = Math.round($mainHeader.offset().top) - headerHeight - (parseInt($main.css('padding-top')) + parseInt($mainHeader.css('margin-top')));

        initialize.done = true;
    }

    var onScrollHandler = function () {
        initialize();
        var currentScrollPosition = $(window).scrollTop();

        // Header
        var isOverHeaderTop = currentScrollPosition > headerTop;

        // Prevent fixed left side bar scroll top
        if (isOverHeaderTop && parseInt($fixedSideBar.css('top')) < headerHeight) {
            $fixedSideBar.css({ top: headerHeight + 'px' });
        }

        // Fixed header, we need this to handle above header messages
        if (!isFixedHeader && isOverHeaderTop) {
            isFixedHeader = true;

            $header.addClass('fixed-header');
            $main.css({ marginTop: headerHeight + 'px' });

            // CONFSERVER-59465: fix chrome collapsed page title header due to body top 0 bizarre behaviour
            var bodyMarginTop = $('body').position().top;
            !bodyMarginTop && $mainHeaderPlaceholder.css(
                'margin-top',
                parseInt($mainHeader.css('margin-top')) + headerHeight + 'px'
            );

        } else if (!isOverHeaderTop) {
            $header.removeClass('fixed-header');
            mainCss.marginTop = '';

            isFixedHeader = false;
        }

        // Main header
        var isOverMainHeaderTop = currentScrollPosition > mainHeaderTop;

        if (!isFixedMainHeader && isOverMainHeaderTop) {
            isFixedMainHeader = true;

            $mainHeader.find('#title-text').hide();

            $mainHeader.css({
                position: 'fixed',
                width: $main.outerWidth() - (parseInt($main.css('padding-left')) + parseInt($main.css('padding-right'))),
                right: 0,
                top: headerHeight + 'px',
                marginTop: 0,
                paddingTop: parseInt($main.css('padding-top')) + parseInt($mainHeader.css('margin-top')),
                paddingBottom: parseInt($main.css('padding-top')) + parseInt($mainHeader.css('margin-top')),
                paddingLeft: $main.css('padding-left'),
                paddingRight: $main.css('padding-right'),
                zIndex: MAIN_HEADER_Z_INDEX
            });

            // Add placeholder
            $mainHeader.before(dom.createMainHeaderPlaceHolder());
        } else if (!isOverMainHeaderTop) {
            mainHeaderCss.position = '';
            mainHeaderCss.width = '';
            mainHeaderCss.right = '';
            mainHeaderCss.top = '';
            mainHeaderCss.marginTop = '';
            mainHeaderCss.paddingTop = '';
            mainHeaderCss.paddingBottom = '';
            mainHeaderCss.paddingLeft = '';
            mainHeaderCss.paddingRight = '';
            mainHeaderCss.zIndex = '';

            $mainHeader.removeClass('overlay-header');

            $mainHeader.find('#title-text').show();

            isFixedMainHeader = false;
            isMainHeaderOverlay = false;

            // Remove placeholder
            dom.removeMainHeaderPlaceHolder();
        }

        // Show/hide nav when scroll up/down
        var mainHeaderTopValue,
            mainHeaderZIndexValue,
            mainHeaderHeight = $mainHeader.outerHeight(),
            windowScrollDiff = scrollPosition - currentScrollPosition,
            mainHeaderCurrentTop = parseInt($mainHeader.css('top')) + windowScrollDiff;

        if (currentScrollPosition <= 0) { // Scrolled to the very top; element sticks to the top
            scrollUpTrackingDistance = 0;
            movingDistance = 0;
            mainHeaderTopValue = headerHeight;
        } else if (isFixedMainHeader && windowScrollDiff > 0) { // Scrolled up; element slides in
            if (mainHeaderCurrentTop > headerHeight) { // Stick main header below header
                scrollUpTrackingDistance = headerHeight;
                movingDistance = 0;
                mainHeaderTopValue = headerHeight;
                mainHeaderZIndexValue = MAIN_HEADER_Z_INDEX;
            } else {
                scrollUpTrackingDistance += Math.abs(windowScrollDiff);
                if (scrollUpTrackingDistance >= BUFFERED_DISTANCE || currentScrollPosition <= mainHeaderHeight) {
                    movingDistance -= Math.abs(windowScrollDiff);
                    mainHeaderTopValue = mainHeaderCurrentTop;
                    mainHeaderZIndexValue = MAIN_HEADER_Z_INDEX;
                }
            }

            if (currentScrollPosition > mainHeaderHeight + BUFFERED_DISTANCE && !isMainHeaderOverlay) {
                $mainHeader.addClass('overlay-header');
                isMainHeaderOverlay = true;
            }

            showMainHeaderBy = SCROLL;
        } else if (isFixedMainHeader && windowScrollDiff < 0) { // Scrolled down
            if (mainHeaderCurrentTop < headerHeight - mainHeaderHeight) { // Completely hidden, stay here
                scrollUpTrackingDistance = 0;
                movingDistance = mainHeaderHeight;
                mainHeaderTopValue = headerHeight - mainHeaderHeight;
                mainHeaderZIndexValue = 0;
            } else {
                movingDistance += Math.abs(windowScrollDiff);
                mainHeaderTopValue = mainHeaderCurrentTop;
            }
        }

        if (mainHeaderZIndexValue !== undefined && mainHeaderTopValue !== undefined) {
            $mainHeader.css({
                top: mainHeaderTopValue + 'px',
                zIndex: mainHeaderZIndexValue
            });
        } else if (mainHeaderTopValue !== undefined) {
            $mainHeader.css({
                top: mainHeaderTopValue + 'px'
            });
        }

        if (isKeepDotDotDotButton) {
            dom.translateVertical($actionMenuLink, movingDistance, $actionMenuLink.attr('id'));
        }
        dom.updateTableStickyHeaderOption();

        scrollPosition = currentScrollPosition;
    };

    /**
     * private helper function
     */
    function displayMainHeader() {
        if (!isFixedMainHeader || movingDistance === 0) {
            return;
        }
        movingDistance = 0;
        $mainHeader.addClass('overlay-header');
        $mainHeader.css({
            top: headerHeight + 'px',
            zIndex: MAIN_HEADER_Z_INDEX
        });
        if (isKeepDotDotDotButton) {
            dom.translateVertical($actionMenuLink, movingDistance, $actionMenuLink.attr('id'));
        }
        dom.updateTableStickyHeaderOption();
    }

    function onHoverActionMenuLinkHandler() {
        initialize();
        displayMainHeader();

        showMainHeaderBy = HOVER;
    }

    function onClickEditPageLinkHandler() {
        initialize();
        displayMainHeader(); // Press E when main header is hidden will cause problem
        AJS.bind('quick-edit.viewport.saved', function () {
            $header.removeAttr('style');
            // Remove placeholder
            dom.removeMainHeaderPlaceHolder();
        });

        $(window).off('scroll', onScrollHandler)
            .off('resize.confluence-fixed-headers-responsive');

        AJS.trigger('analyticsEvent', {
            name: 'view.edit.transition.edit.button.clicked',
            data: { method: showMainHeaderBy }
        });
    }

    /* public functions */
    exports.forceInitialize = function () {
        initialize(true);
    };
    exports.onScrollHandler = onScrollHandler;
    exports.onHoverActionMenuLinkHandler = onHoverActionMenuLinkHandler;
    exports.onClickEditPageLinkHandler = onClickEditPageLinkHandler;

    /* public properties */
    exports.isKeepDotDotDotButton = isKeepDotDotDotButton;

    /* support testing */
    /* get value */
    exports.__getShowMainHeaderBy = function () {
        return showMainHeaderBy;
    };
    exports.__getFixedHeader = function () {
        return isFixedHeader;
    };
    exports.__getFixedMainHeader = function () {
        return isFixedMainHeader;
    };
    /* set value */
    exports.__setFixedHeader = function (isFixed) {
        isFixedHeader = isFixed;
    };
    exports.__setFixedMainHeader = function (isFixed) {
        isFixedMainHeader = isFixed;
    };
    exports.__setMainHeaderOverlay = function (isOverlay) {
        isMainHeaderOverlay = isOverlay;
    };
    exports.__setScrollPosition = function (position) {
        scrollPosition = position;
    };
    exports.__setMovingDistance = function (distance) {
        movingDistance = distance;
    };
});
