/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.featurediscovery.manager;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugins.featurediscovery.FeatureCompleteKey;
import com.atlassian.confluence.plugins.featurediscovery.FeatureMetadata;
import com.atlassian.confluence.plugins.featurediscovery.entity.FeatureMetadataAo;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureMetadataManager {
    private static final Logger log = LoggerFactory.getLogger(FeatureMetadataManager.class);
    private final ActiveObjects ao;
    protected static final int BATCH_SIZE = 50;

    public FeatureMetadataManager(ActiveObjects ao) {
        this.ao = ao;
    }

    public boolean hasData() {
        return (Boolean)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                FeatureMetadataAo[] featureMetadatas = (FeatureMetadataAo[])FeatureMetadataManager.this.ao.find(FeatureMetadataAo.class, Query.select().limit(1));
                return featureMetadatas.length > 0;
            }
        });
    }

    public FeatureMetadata save(final FeatureCompleteKey featureCompleteKey, final Date installationDate) {
        return new FeatureMetadata((FeatureMetadataAo)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<FeatureMetadataAo>(){

            public FeatureMetadataAo doInTransaction() {
                FeatureMetadataAo existingFeatureMetadata = FeatureMetadataManager.this.find(featureCompleteKey);
                if (existingFeatureMetadata != null) {
                    return existingFeatureMetadata;
                }
                FeatureMetadataAo featureMetadataAo = (FeatureMetadataAo)FeatureMetadataManager.this.ao.create(FeatureMetadataAo.class, new DBParam[0]);
                featureMetadataAo.setContext(featureCompleteKey.getContext());
                featureMetadataAo.setKey(featureCompleteKey.getKey());
                featureMetadataAo.setInstallationDate(installationDate);
                featureMetadataAo.save();
                return featureMetadataAo;
            }
        }));
    }

    public Date getInstallationDate(FeatureCompleteKey featureCompleteKey) {
        String key;
        final String context = featureCompleteKey.getContext();
        FeatureMetadataAo featureMetadataEntity = (FeatureMetadataAo)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<FeatureMetadataAo>(key = featureCompleteKey.getKey()){
            final /* synthetic */ String val$key;
            {
                this.val$key = string2;
            }

            public FeatureMetadataAo doInTransaction() {
                FeatureMetadataAo[] featureMetadatas = (FeatureMetadataAo[])FeatureMetadataManager.this.ao.find(FeatureMetadataAo.class, Query.select((String)"ID, INSTALLATION_DATE").where("CONTEXT = ? AND KEY = ?", new Object[]{context, this.val$key}).order("INSTALLATION_DATE ASC"));
                if (featureMetadatas.length == 0) {
                    return null;
                }
                if (featureMetadatas.length != 1) {
                    log.warn("Found more than 1 installation date entry for feature: {}:{}", (Object)context, (Object)this.val$key);
                }
                return featureMetadatas[0];
            }
        });
        if (featureMetadataEntity == null) {
            return null;
        }
        return featureMetadataEntity.getInstallationDate();
    }

    public boolean delete(final FeatureCompleteKey featureCompleteKey) {
        return (Boolean)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                FeatureMetadataAo featureMetadata = FeatureMetadataManager.this.find(featureCompleteKey);
                if (featureMetadata == null) {
                    return false;
                }
                FeatureMetadataManager.this.ao.delete(new RawEntity[]{featureMetadata});
                return true;
            }
        });
    }

    public List<FeatureMetadata> getFeatures(final List<FeatureCompleteKey> featureCompleteKeys) {
        FeatureMetadataAo[] pluginModuleEntities = (FeatureMetadataAo[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<FeatureMetadataAo[]>(){

            public FeatureMetadataAo[] doInTransaction() {
                return FeatureMetadataManager.this.getFeatureMetadataAosFromFeaturesInBatches(featureCompleteKeys);
            }
        });
        return Lists.transform(Arrays.asList(pluginModuleEntities), (Function)new Function<FeatureMetadataAo, FeatureMetadata>(){

            public FeatureMetadata apply(FeatureMetadataAo featureMetadataAo) {
                return new FeatureMetadata(featureMetadataAo);
            }
        });
    }

    public List<FeatureMetadata> getModules(final List<ModuleCompleteKey> moduleCompleteKeys) {
        FeatureMetadataAo[] pluginModuleEntities = (FeatureMetadataAo[])this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<FeatureMetadataAo[]>(){

            public FeatureMetadataAo[] doInTransaction() {
                return FeatureMetadataManager.this.getFeatureMetadataAosFromModules(moduleCompleteKeys);
            }
        });
        return Lists.transform(Arrays.asList(pluginModuleEntities), (Function)new Function<FeatureMetadataAo, FeatureMetadata>(){

            public FeatureMetadata apply(@Nullable FeatureMetadataAo featureMetadataAo) {
                return new FeatureMetadata(featureMetadataAo);
            }
        });
    }

    public void save(final List<FeatureMetadata> featureMetadatas) {
        final HashMap featureMetadatasToSave = Maps.newHashMap();
        for (FeatureMetadata featureMetadata : featureMetadatas) {
            featureMetadatasToSave.put(featureMetadata.getFeatureCompleteKey(), featureMetadata);
        }
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                List moduleCompleteKeys = Lists.transform((List)featureMetadatas, (Function)new Function<FeatureMetadata, ModuleCompleteKey>(){

                    public ModuleCompleteKey apply(FeatureMetadata featureMetadata) {
                        return new ModuleCompleteKey(featureMetadata.getContext(), featureMetadata.getKey());
                    }
                });
                FeatureMetadataAo[] existingModuleMetadatas = FeatureMetadataManager.this.getFeatureMetadataAosFromModules(moduleCompleteKeys);
                for (FeatureMetadataAo existingModuleMetadata : existingModuleMetadatas) {
                    featureMetadatasToSave.remove(new FeatureCompleteKey(existingModuleMetadata.getContext(), existingModuleMetadata.getKey()));
                }
                for (FeatureMetadata featureMetadata : featureMetadatasToSave.values()) {
                    log.debug("Found new plugin module: {}", (Object)featureMetadata.getContext());
                    FeatureMetadataAo pluginModuleEntity = (FeatureMetadataAo)FeatureMetadataManager.this.ao.create(FeatureMetadataAo.class, new DBParam[0]);
                    pluginModuleEntity.setContext(featureMetadata.getContext());
                    pluginModuleEntity.setKey(featureMetadata.getKey());
                    pluginModuleEntity.setInstallationDate(featureMetadata.getInstallationDate());
                    pluginModuleEntity.save();
                }
                return null;
            }
        });
    }

    private FeatureMetadataAo find(FeatureCompleteKey featureCompleteKey) {
        String context = featureCompleteKey.getContext();
        String key = featureCompleteKey.getKey();
        Query query = Query.select().where("CONTEXT = ? AND KEY = ?", new Object[]{context, key}).order("INSTALLATION_DATE ASC");
        FeatureMetadataAo[] featureMetadatas = (FeatureMetadataAo[])this.ao.find(FeatureMetadataAo.class, query);
        if (featureMetadatas.length > 1) {
            log.warn("Found more than 1 installation date entry for feature: {}:{}", (Object)context, (Object)key);
        }
        if (featureMetadatas.length > 0) {
            return featureMetadatas[0];
        }
        return null;
    }

    private FeatureMetadataAo[] getFeatureMetadataAosFromModules(List<ModuleCompleteKey> moduleCompleteKeys) {
        return this.getFeatureMetadataAosFromFeaturesInBatches(Lists.transform(moduleCompleteKeys, (Function)new Function<ModuleCompleteKey, FeatureCompleteKey>(){

            public FeatureCompleteKey apply(@Nullable ModuleCompleteKey moduleCompleteKey) {
                return new FeatureCompleteKey(moduleCompleteKey);
            }
        }));
    }

    private FeatureMetadataAo[] getFeatureMetadataAosFromFeaturesInBatches(List<FeatureCompleteKey> featureCompleteKeys) {
        ArrayList result = new ArrayList(featureCompleteKeys.size());
        int totalSize = featureCompleteKeys.size();
        for (int i = 0; i < totalSize; i += 50) {
            int toIndex = Math.min(i + 50, totalSize);
            Collections.addAll(result, this.getFeatureMetadataAosFromFeatures(featureCompleteKeys.subList(i, toIndex)));
        }
        return result.toArray(new FeatureMetadataAo[result.size()]);
    }

    private FeatureMetadataAo[] getFeatureMetadataAosFromFeatures(List<FeatureCompleteKey> featureCompleteKeys) {
        int size = featureCompleteKeys.size();
        if (size == 0) {
            return new FeatureMetadataAo[0];
        }
        Query query = Query.select();
        StringBuilder whereClause = new StringBuilder();
        Object[] whereParams = new String[size * 2];
        int numFilledWhereParams = 0;
        Iterator<FeatureCompleteKey> it = featureCompleteKeys.iterator();
        while (it.hasNext()) {
            FeatureCompleteKey featureCompleteKey = it.next();
            whereClause.append("(CONTEXT = ? AND KEY = ?)");
            if (it.hasNext()) {
                whereClause.append(" OR ");
            }
            whereParams[numFilledWhereParams++] = featureCompleteKey.getContext();
            whereParams[numFilledWhereParams++] = featureCompleteKey.getKey();
        }
        query.setWhereClause(whereClause.toString());
        query.setWhereParams(whereParams);
        return (FeatureMetadataAo[])this.ao.find(FeatureMetadataAo.class, query);
    }
}

