/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.index.api;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.index.api.FieldDescriptor;
import com.atlassian.confluence.plugins.index.api.FieldVisitor;

@Internal
abstract class AbstractFieldDescriptor {
    protected final String name;
    protected final String value;
    protected final FieldDescriptor.Index index;
    protected final FieldDescriptor.Store store;

    public AbstractFieldDescriptor(FieldDescriptor.Store store, String name, FieldDescriptor.Index index, String value) {
        this.store = store;
        this.name = name;
        this.index = index;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public FieldDescriptor.Index getIndex() {
        return this.index;
    }

    public FieldDescriptor.Store getStore() {
        return this.store;
    }

    public abstract <T> T accept(FieldVisitor<T> var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDescriptor that = (FieldDescriptor)o;
        if (this.index != that.index) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.store != that.store) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        result = 31 * result + this.index.hashCode();
        result = 31 * result + this.store.hashCode();
        return result;
    }
}

