/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.index.api;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.plugins.index.api.AnalyzerDescriptor;
import com.atlassian.confluence.plugins.index.api.AnalyzerDescriptorProvider;
import com.atlassian.confluence.plugins.index.api.LanguageDescriptor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@ExperimentalApi
public final class LanguageAnalyzerDescriptor
implements AnalyzerDescriptorProvider {
    private final AnalyzerDescriptor analyzer;
    private final Map<LanguageDescriptor, AnalyzerDescriptor> languageSpecificAnalyzers;

    private LanguageAnalyzerDescriptor(Builder builder) {
        this.analyzer = builder.analyzer;
        this.languageSpecificAnalyzers = new HashMap<LanguageDescriptor, AnalyzerDescriptor>(builder.languageSpecificAnalyzers);
    }

    @Override
    public Optional<AnalyzerDescriptor> getAnalyzer(LanguageDescriptor language) {
        return Optional.ofNullable(this.languageSpecificAnalyzers.getOrDefault(language, this.analyzer));
    }

    public static Builder builder(AnalyzerDescriptor analyzer) {
        return new Builder(analyzer);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LanguageAnalyzerDescriptor)) {
            return false;
        }
        LanguageAnalyzerDescriptor that = (LanguageAnalyzerDescriptor)o;
        return this.analyzer.equals(that.analyzer) && this.languageSpecificAnalyzers.equals(that.languageSpecificAnalyzers);
    }

    public int hashCode() {
        return Objects.hash(this.analyzer, this.languageSpecificAnalyzers);
    }

    public static class Builder {
        private final AnalyzerDescriptor analyzer;
        private final Map<LanguageDescriptor, AnalyzerDescriptor> languageSpecificAnalyzers;

        private Builder(@Nullable AnalyzerDescriptor analyzer) {
            this.analyzer = analyzer;
            this.languageSpecificAnalyzers = new HashMap<LanguageDescriptor, AnalyzerDescriptor>();
        }

        public Builder analyzer(LanguageDescriptor language, AnalyzerDescriptor analyzer) {
            this.languageSpecificAnalyzers.put(language, analyzer);
            return this;
        }

        public LanguageAnalyzerDescriptor build() {
            return new LanguageAnalyzerDescriptor(this);
        }
    }
}

