/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.polling;

import com.atlassian.confluence.mail.ConfluencePopMailServer;
import com.google.common.base.Predicate;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MessageRecipientFilter
implements Predicate<MimeMessage> {
    private final String expectedAddress;

    public MessageRecipientFilter(ConfluencePopMailServer popMailServer) {
        this.expectedAddress = popMailServer.getToAddress();
    }

    public boolean apply(MimeMessage input) {
        try {
            Address[] recipients = input.getRecipients(Message.RecipientType.TO);
            if (recipients == null) {
                return false;
            }
            for (Address recipient : recipients) {
                String actualAddress = ((InternetAddress)recipient).getAddress();
                if (!actualAddress.equals(this.expectedAddress)) continue;
                return true;
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return false;
    }
}

