/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.api;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.ConfluencePopMailServer;
import com.atlassian.confluence.plugins.emailgateway.api.PopMailServerManager;
import com.atlassian.mail.Email;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

@PublicApi
public class NotificationEmailHelper {
    private final PopMailServerManager popMailServerManager;

    public NotificationEmailHelper(PopMailServerManager popMailServerManager) {
        this.popMailServerManager = (PopMailServerManager)Preconditions.checkNotNull((Object)popMailServerManager);
    }

    @Nullable
    public ContentEntityObject extractTargetContentFromEmailReply(Map<String, List<String>> headers, ContentFinder contentFinder) {
        Long contentId = this.extractContentIdFromReferencesHeader(headers);
        return contentId != null ? contentFinder.findContentById(contentId) : null;
    }

    @Nullable
    private Long extractContentIdFromReferencesHeader(Map<String, List<String>> headers) {
        List<String> referenceHeaders = headers.get("References");
        if (referenceHeaders == null) {
            return null;
        }
        for (String referenceHeader : referenceHeaders) {
            Optional<Long> first;
            String[] potentialMessageIds = StringUtils.split((String)referenceHeader, (char)' ');
            if (potentialMessageIds == null || !(first = Arrays.stream(potentialMessageIds).map(this::extractContentId).filter(Objects::nonNull).findFirst()).isPresent()) continue;
            return first.get();
        }
        return null;
    }

    public void populateTrackingHeaders(Email mail, Long contentId) {
        mail.setMessageId(this.generateEmailMessageId(contentId));
        mail.setReplyTo(this.getEmailReplyToAddress());
    }

    private String generateEmailMessageId(Long contentId) {
        return String.format("contentId-%s-%s%s", contentId, RandomStringUtils.randomNumeric((int)10), this.getMessageIdSuffix());
    }

    @Nullable
    private Long extractContentId(String messageId) {
        Pattern pattern = Pattern.compile("^<CONFLUENCE.(?<contentId>\\d+).\\d.\\d+@([a-zA-Z0-9]+)>$");
        Matcher matcher = pattern.matcher(messageId.trim());
        return matcher.matches() ? Long.valueOf(matcher.group("contentId")) : null;
    }

    private String getMessageIdSuffix() {
        String replyToAddress = this.getEmailReplyToAddress();
        return replyToAddress != null ? replyToAddress.substring(replyToAddress.lastIndexOf("@")) : "@confluence.localhost";
    }

    private String getEmailReplyToAddress() {
        ConfluencePopMailServer popMailServer = (ConfluencePopMailServer)this.popMailServerManager.getPopMailServer();
        return popMailServer != null ? popMailServer.getToAddress() : null;
    }

    public static interface ContentFinder {
        public ContentEntityObject findContentById(long var1);
    }
}

