/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.attachmentconverter.instances;

import com.atlassian.confluence.plugins.emailgateway.api.AttachmentConverter;
import com.atlassian.confluence.plugins.emailgateway.api.AttachmentFile;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultimediaAttachmentConverter
implements AttachmentConverter<MacroDefinition> {
    private static final Set<String> SUPPORTED_MULTIMEDIA_EXTENSIONS = new HashSet<String>(){
        {
            this.add("rm");
            this.add("ram");
            this.add("mpeg");
            this.add("mpg");
            this.add("wmv");
            this.add("wma");
            this.add("mpeg");
            this.add("swf");
            this.add("mov");
            this.add("mp4");
            this.add("mp3");
            this.add("avi");
        }
    };

    @Override
    public MacroDefinition convertAttachment(AttachmentFile attachmentFile) {
        if (!SUPPORTED_MULTIMEDIA_EXTENSIONS.contains(attachmentFile.getExtension())) {
            return null;
        }
        Map<String, String> params = Collections.singletonMap("name", attachmentFile.getFileName());
        return new MacroDefinition("multimedia", null, null, params);
    }

    @Override
    public Class<MacroDefinition> getConversionClass() {
        return MacroDefinition.class;
    }
}

