/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.conversion.api.ConversionResult;
import com.atlassian.confluence.plugins.conversion.api.ConversionResultSupplier;
import com.atlassian.confluence.plugins.conversion.api.ConversionStatus;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.plugins.conversion.api.LocalFileSystemConversionResult;
import com.atlassian.confluence.plugins.conversion.impl.ConfigurationProperties;
import com.atlassian.confluence.plugins.conversion.impl.FileStoreConversionResultSupplier;
import com.atlassian.confluence.plugins.conversion.impl.FileStoreMode;
import com.atlassian.confluence.plugins.conversion.impl.FileSystemConversionState;
import com.atlassian.confluence.plugins.conversion.impl.TimeoutConversionRunnable;
import com.atlassian.confluence.plugins.conversion.impl.runnable.JVMConversionRunnable;
import com.atlassian.confluence.plugins.conversion.impl.runnable.MemoryReserveService;
import com.atlassian.confluence.plugins.conversion.impl.runnable.cloud.CloudConversionRunnable;
import com.atlassian.confluence.web.rangerequest.RangeNotSatisfiableException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.AppWithCapabilities;
import com.atlassian.plugins.capabilities.api.CapabilityService;
import com.atlassian.plugins.conversion.convert.FileFormat;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="localFileSystemConversionResultSupplier")
public class LocalFileSystemConversionResultSupplier
extends ConversionResultSupplier {
    private static final Logger log = LoggerFactory.getLogger(LocalFileSystemConversionResultSupplier.class);
    private static final int INITIAL_THREADS = 1;
    private static final int N_THREADS_CLOUD = ConfigurationProperties.getInt(ConfigurationProperties.PROP_NUM_THREADS_CLOUD);
    private static final int N_THREADS_WAIT = ConfigurationProperties.getInt(ConfigurationProperties.PROP_NUM_THREADS_WAIT);
    private static final int N_THREADS_CLOUD_WAIT = ConfigurationProperties.getInt(ConfigurationProperties.PROP_NUM_THREADS_CLOUD_WAIT);
    private static final int N_THREADS_THUMBNAIL_WAIT = ConfigurationProperties.getInt(ConfigurationProperties.PROP_NUM_THUMBNAIL_THREADS_WAIT);
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(N_THREADS_WAIT), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("conversion-thread-%d").setPriority(1).build(), new ThreadPoolExecutor.AbortPolicy());
    private static final ThreadPoolExecutor executorPdfThumbnail = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(N_THREADS_THUMBNAIL_WAIT), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("conversion-thread-pdf-thumb-%d").setPriority(1).build(), new ThreadPoolExecutor.AbortPolicy());
    private static final ThreadPoolExecutor executorCloud = new ThreadPoolExecutor(N_THREADS_CLOUD, N_THREADS_CLOUD, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(N_THREADS_CLOUD_WAIT), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("conversion-thread-cloud-%d").setPriority(1).build(), new ThreadPoolExecutor.AbortPolicy());
    private static final int THREAD_POOL_SIZE = Integer.getInteger("atlassian.filestore.conversion.thread_pool_size", 4);
    private final ExecutorService fileStoreStatsExecutor = Executors.newFixedThreadPool(THREAD_POOL_SIZE);
    private static final String CLOUD_CONVERSION_LOCK_PREFIX = "cloud.document.conversion.lock";
    private static final Map<ConversionType, String> CONVERSION_LOCK_PREFIXES = new HashMap<ConversionType, String>(){
        {
            for (ConversionType type : ConversionType.values()) {
                this.put(type, "document.conversion.lock." + type.name().toLowerCase() + ".");
            }
        }
    };
    private static final long CONVERSION_TIMEOUT = TimeUnit.MINUTES.toSeconds(4L);
    private final ConversionResultSupplier fileStoreConversionResultSupplier;
    private final AttachmentManager attachmentManager;
    private final ClusterLockService clusterLockService;
    private final CapabilityService capabilityService;
    private final HostApplication hostApplication;
    private final TransactionTemplate transactionTemplate;
    private final MemoryReserveService memoryReserveService;

    @Autowired
    public LocalFileSystemConversionResultSupplier(FileStoreConversionResultSupplier fileStoreConversionResultSupplier, @ComponentImport AttachmentManager attachmentManager, @ComponentImport ClusterLockService clusterLockService, @ComponentImport CapabilityService capabilityService, @ComponentImport HostApplication hostApplication, @ComponentImport TransactionTemplate transactionTemplate, MemoryReserveService memoryReserveService) {
        this.fileStoreConversionResultSupplier = fileStoreConversionResultSupplier;
        this.attachmentManager = attachmentManager;
        this.clusterLockService = clusterLockService;
        this.capabilityService = capabilityService;
        this.hostApplication = hostApplication;
        this.transactionTemplate = transactionTemplate;
        this.memoryReserveService = memoryReserveService;
    }

    @Override
    public ConversionResult getConversionResult(Attachment attachment, ConversionType conversionType) {
        FileSystemConversionState conversionState = new FileSystemConversionState(attachment, conversionType);
        AppWithCapabilities hostApp = this.capabilityService.getHostApplication();
        boolean conversionsEnabled = hostApp.hasCapability(ConfigurationProperties.PROP_CAPABILITY.toString());
        if (conversionsEnabled && !conversionState.isConverted() && !conversionState.isError()) {
            boolean cloudEnabled = hostApp.hasCapability(ConfigurationProperties.PROP_CAPABILITY_CLOUD.toString());
            String cloudUrl = cloudEnabled ? hostApp.getCapabilityUrl(ConfigurationProperties.PROP_CAPABILITY_CLOUD.toString()) : null;
            TimeoutConversionRunnable conversionTask = new TimeoutConversionRunnable(attachment, conversionType, this.clusterLockService, this.getConversionRunnable(attachment, conversionType, conversionState, cloudUrl), conversionState, LocalFileSystemConversionResultSupplier.getConversionLockPrefix(conversionType, cloudUrl != null), CONVERSION_TIMEOUT);
            try {
                if (cloudEnabled) {
                    executorCloud.execute(conversionTask);
                } else if (ConversionType.THUMBNAIL.equals((Object)conversionType) && FileFormat.PDF.equals((Object)this.conversionManager.getFileFormat(attachment))) {
                    this.queueIfNotDuplicate(executorPdfThumbnail, conversionTask);
                } else {
                    this.queueIfNotDuplicate(executor, conversionTask);
                }
            }
            catch (RejectedExecutionException e) {
                log.warn("The conversion service is currently busy.", (Throwable)e);
                conversionState.markAsBusy();
            }
        }
        return new LocalFileSystemConversionResult(conversionType, attachment, conversionState.getStatus(), this.conversionManager.getConversionUrl(attachment.getId(), attachment.getVersion(), conversionType), conversionState.getConvertedFile(), this.getFileStoreConversionTracker(attachment, conversionType));
    }

    private void queueIfNotDuplicate(ThreadPoolExecutor threadPoolExecutor, Runnable conversionTask) {
        if (!threadPoolExecutor.getQueue().contains(conversionTask)) {
            threadPoolExecutor.execute(conversionTask);
        }
    }

    private Consumer<Optional<String>> getFileStoreConversionTracker(Attachment attachment, ConversionType conversionType) {
        if (FileStoreMode.Mode.DUAL_PRIMARY_TICKET.equals((Object)FileStoreMode.getValue()) && attachment.getFileStoreId() != null) {
            return rangeHeader -> this.fileStoreStatsExecutor.execute(() -> {
                ConversionResult result = this.fileStoreConversionResultSupplier.getConversionResult(attachment, conversionType);
                if (ConversionStatus.CONVERTED.equals((Object)result.getConversionStatus())) {
                    try {
                        StreamingOutput output = result.getConversionData((Optional<String>)rangeHeader).getStreamingOutput();
                        output.write((OutputStream)new NullOutputStream());
                        log.debug("Finished reading conversion stream from FileStore for attachment {}", (Object)attachment.getId());
                    }
                    catch (RangeNotSatisfiableException | FileNotFoundException output) {
                    }
                    catch (IOException | RuntimeException e) {
                        log.error("Unexpected error downloading conversion from FileStore for attachment {} fileStoreId: {}", new Object[]{attachment.getId(), attachment.getFileStoreId(), e});
                    }
                }
            });
        }
        return null;
    }

    private static String getConversionLockPrefix(ConversionType conversionType, boolean cloudMode) {
        return cloudMode ? CLOUD_CONVERSION_LOCK_PREFIX : CONVERSION_LOCK_PREFIXES.get((Object)conversionType);
    }

    private Runnable getConversionRunnable(Attachment attachment, ConversionType conversionType, FileSystemConversionState conversionState, String cloudUrl) {
        return cloudUrl == null ? new JVMConversionRunnable(conversionState, attachment, this.conversionManager.getFileFormat(attachment), this.attachmentManager, conversionType, this.conversionManager.getConverters(), this.memoryReserveService) : new CloudConversionRunnable(cloudUrl, attachment, this.attachmentManager, this.hostApplication, this.transactionTemplate);
    }

    public void setJvmThreadPoolSize(int jvmThreadPoolSize) {
        executor.setCorePoolSize(jvmThreadPoolSize);
        executor.setMaximumPoolSize(jvmThreadPoolSize);
    }

    public int getJvmThreadPoolSize() {
        return executor.getCorePoolSize();
    }

    public int getConversionQueueSize() {
        return executor.getQueue().size();
    }
}

