/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.persistence.dao.filesystem.HierarchicalContentFileSystemHelper;
import com.atlassian.confluence.plugins.conversion.api.ConversionStatus;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSystemConversionState {
    public static final String MIME_SUFFIX = "mime";
    private static final HierarchicalContentFileSystemHelper fileSystemHelper = new HierarchicalContentFileSystemHelper();
    private static final Map<ConversionType, String> PREFIXES = new HashMap<ConversionType, String>(){
        {
            for (ConversionType type : ConversionType.values()) {
                this.put(type, File.separator + "dcl-" + type.name().toLowerCase() + File.separator);
            }
        }
    };
    private static BootstrapManager bootstrapManager = (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
    private final File tempFile;
    private final File convertedFile;
    private final File errorFile;
    private boolean isBusy = false;

    public FileSystemConversionState(Attachment attachment, ConversionType conversionType) {
        this.tempFile = FileSystemConversionState.getStatusFileWithExtension(attachment, conversionType, ConversionStatus.IN_PROGRESS);
        this.convertedFile = FileSystemConversionState.getStatusFileWithExtension(attachment, conversionType, ConversionStatus.CONVERTED);
        this.errorFile = FileSystemConversionState.getStatusFileWithExtension(attachment, conversionType, ConversionStatus.ERROR);
    }

    public File getTempFile() {
        return this.tempFile;
    }

    public File getConvertedFile() {
        return this.convertedFile;
    }

    @VisibleForTesting
    public File getErrorFile() {
        return this.errorFile;
    }

    public boolean isConverted() {
        return this.convertedFile.exists() && this.convertedFile.length() != 0L;
    }

    public boolean isError() {
        return this.errorFile.exists() || this.convertedFile.exists() && this.convertedFile.length() == 0L;
    }

    public ConversionStatus getStatus() {
        if (this.isConverted()) {
            return ConversionStatus.CONVERTED;
        }
        if (this.isError()) {
            return ConversionStatus.ERROR;
        }
        if (this.isBusy) {
            return ConversionStatus.BUSY;
        }
        return ConversionStatus.IN_PROGRESS;
    }

    public void markAsError() {
        try {
            this.errorFile.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create error file", e);
        }
    }

    public static Collection<File> getConversionDirectories() {
        ImmutableSet.Builder directories = ImmutableSet.builder();
        for (String conversionType : PREFIXES.values()) {
            directories.add((Object)FileSystemConversionState.getRootStorageDirectory(conversionType));
        }
        return directories.build();
    }

    public void markAsBusy() {
        this.isBusy = true;
    }

    private static File getRootStorageDirectory(String pathSuffix) {
        return new File(bootstrapManager.getSharedHome() + pathSuffix);
    }

    public static File getStorageFolder(Attachment attachment, ConversionType conversionType) {
        return fileSystemHelper.createDirectoryHierarchy(FileSystemConversionState.getRootStorageDirectory(PREFIXES.get((Object)conversionType)), attachment.getContainer().getId());
    }

    public static FileFilter getStatusFileFilter(final Attachment attachment) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                Pattern filePattern = Pattern.compile(Long.toString(((Attachment)attachment.getLatestVersion()).getId()) + "_" + Integer.toString(attachment.getVersion()) + ".*");
                Matcher fileMatcher = filePattern.matcher(file.getName());
                return fileMatcher.matches();
            }
        };
    }

    public static File getStatusFileWithExtension(Attachment attachment, ConversionType conversionType, ConversionStatus conversionStatus) {
        return new File(FileSystemConversionState.getStorageFolder(attachment, conversionType), Long.toString(((Attachment)attachment.getLatestVersion()).getId()) + "_" + Integer.toString(attachment.getVersion()) + FileSystemConversionState.getFileExtension(conversionStatus));
    }

    private static String getFileExtension(ConversionStatus conversionStatus) {
        switch (conversionStatus) {
            case CONVERTED: {
                return "";
            }
            case ERROR: {
                return ".err";
            }
            case IN_PROGRESS: {
                return "-" + Thread.currentThread().getId() + ".tmp";
            }
            case BUSY: {
                return null;
            }
        }
        return null;
    }

    @VisibleForTesting
    static void setBootstrapManager(BootstrapManager bootstrapManager) {
        FileSystemConversionState.bootstrapManager = bootstrapManager;
    }
}

