/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.extract.binary;

import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.confluence.plugins.conversion.extract.binary.AbstractBinaryExtractor;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class SlidesBinaryExtractor
extends AbstractBinaryExtractor {
    public static String extractText(InputStream inputStream) throws ExtractorException {
        try {
            POIFSFileSystem system = new POIFSFileSystem(inputStream);
            try {
                DirectoryNode root = system.getRoot();
                root.getEntry("Pictures").delete();
                root.createDocument("Pictures", new ByteArrayInputStream(new byte[0]));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return new PowerPointExtractor(system).getText();
        }
        catch (Exception e) {
            throw new ExtractorException("Error reading content of PowerPoint document: " + e.getMessage(), (Throwable)e);
        }
    }
}

