/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.exceptions.ResourceException;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.plugins.createcontent.rest.BlueprintWebItemService;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateDialogWebItemEntity;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.util.i18n.DocumentationBean;
import com.atlassian.confluence.util.i18n.DocumentationBeanFactory;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.user.User;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;

@Path(value="/space-blueprint/dialog")
public class SpaceBlueprintDialogResource
extends AbstractRestResource {
    private final PermissionManager permissionManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final DocumentationBeanFactory documentationBeanFactory;
    private final BlueprintWebItemService webItemService;
    private final PersonalInformationManager personalInformationManager;

    public SpaceBlueprintDialogResource(PermissionManager permissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, DocumentationBeanFactory documentationBeanFactory, BlueprintWebItemService webItemService, PersonalInformationManager personalInformationManager) {
        super(permissionManager, spaceManager, spacePermissionManager);
        this.permissionManager = permissionManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.documentationBeanFactory = documentationBeanFactory;
        this.webItemService = webItemService;
        this.personalInformationManager = personalInformationManager;
    }

    @GET
    @Path(value="web-items")
    @AnonymousAllowed
    public List<CreateDialogWebItemEntity> getWebItems() {
        ConfluenceUser remoteUser = this.getUser();
        boolean canCreateSpaces = this.userCanCreateSpace(remoteUser);
        boolean canCreatePersonalSpaces = this.userCanCreatePersonalSpace(remoteUser);
        if (!canCreateSpaces && !canCreatePersonalSpaces) {
            throw new ResourceException("You are not permitted to create spaces or personal spaces.", Response.Status.FORBIDDEN, remoteUser == null ? ResourceErrorType.PERMISSION_ANONYMOUS_CREATE_SPACE : ResourceErrorType.PERMISSION_USER_CREATE_SPACE, (Object)(remoteUser == null ? null : remoteUser.getName()));
        }
        I18NBean i18NBean = this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)remoteUser));
        DocumentationBean documentationBean = this.documentationBeanFactory.getDocumentationBean();
        return !canCreateSpaces ? this.webItemService.getCreatePersonalSpaceWebItems(i18NBean, documentationBean, remoteUser) : this.webItemService.getCreateSpaceWebItems(i18NBean, documentationBean, remoteUser);
    }

    private boolean userCanCreateSpace(ConfluenceUser user) {
        return this.permissionManager.hasCreatePermission((User)user, PermissionManager.TARGET_APPLICATION, Space.class);
    }

    private boolean userCanCreatePersonalSpace(ConfluenceUser user) {
        return this.permissionManager.hasCreatePermission((User)user, (Object)this.personalInformationManager.getOrCreatePersonalInformation((User)user), Space.class);
    }
}

