/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.SpaceBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintModuleDescriptor;
import com.atlassian.confluence.plugins.createcontent.rest.AbstractRestResource;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.PluginAccessor;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/admin")
public class BlueprintsAdminResource
extends AbstractRestResource {
    private final SpaceBlueprintManager spaceBlueprintManager;
    private final ContentBlueprintManager contentBlueprintManager;
    private final ContentTemplateRefManager contentTemplateManager;
    private final PluginAccessor pluginAccessor;

    public BlueprintsAdminResource(@Qualifier(value="spaceBlueprintManager") SpaceBlueprintManager spaceBlueprintManager, ContentBlueprintManager contentBlueprintManager, ContentTemplateRefManager contentTemplateManager, PermissionManager permissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, PluginAccessor pluginAccessor) {
        super(permissionManager, spaceManager, spacePermissionManager);
        this.spaceBlueprintManager = spaceBlueprintManager;
        this.contentBlueprintManager = contentBlueprintManager;
        this.contentTemplateManager = contentTemplateManager;
        this.pluginAccessor = pluginAccessor;
    }

    @POST
    @Path(value="refreshAoTables")
    @Consumes(value={"application/json"})
    public int refreshAoTables() {
        this.checkAdminPermission();
        this.spaceBlueprintManager.deleteAll();
        this.contentBlueprintManager.deleteAll();
        this.contentTemplateManager.deleteAll();
        int refreshed = this.refreshContentBlueprints();
        return refreshed += this.spaceBlueprintManager.getAll().size();
    }

    private int refreshContentBlueprints() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(BlueprintModuleDescriptor.class);
        for (BlueprintModuleDescriptor moduleDescriptor : moduleDescriptors) {
            this.contentBlueprintManager.getPluginBackedContentBlueprint(moduleDescriptor.getBlueprintKey(), null);
        }
        return moduleDescriptors.size();
    }
}

