/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.plugins.createcontent.extensions.UserBlueprintConfigManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.xwork.FlashScope;
import com.atlassian.event.api.EventListener;
import java.util.UUID;

public class FirstBlueprintCreationListener {
    private final UserBlueprintConfigManager userBlueprintConfigManager;

    public FirstBlueprintCreationListener(UserBlueprintConfigManager userBlueprintConfigManager) {
        this.userBlueprintConfigManager = userBlueprintConfigManager;
    }

    @EventListener
    public void onBlueprintCreateEvent(BlueprintPageCreateEvent event) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return;
        }
        UUID id = event.getBlueprint().getId();
        if (this.userBlueprintConfigManager.isFirstBlueprintOfTypeForUser(id, user)) {
            this.userBlueprintConfigManager.setBlueprintCreatedByUser(id, user);
            FlashScope.put((String)"firstBlueprintForUser", (Object)id);
            FlashScope.put((String)"com.atlassian.confluence.plugins.confluence-create-content-plugin.blueprint-index-disabled", (Object)event.getBlueprint().isIndexDisabled());
        }
    }
}

