/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.exceptions;

import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.confluence.plugins.createcontent.api.exceptions.RestTypedException;
import com.atlassian.confluence.plugins.createcontent.exceptions.ResourceException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class RestExceptionMapper
implements ExceptionMapper<Exception> {
    public Response toResponse(Exception exception) {
        if (exception instanceof WebApplicationException) {
            return ((WebApplicationException)exception).getResponse();
        }
        if (exception instanceof RestTypedException) {
            RestTypedException restTypedException = (RestTypedException)((Object)exception);
            return ResourceException.makeResponse(exception.getMessage(), Response.Status.BAD_REQUEST, restTypedException.getErrorType(), restTypedException.getErrorData());
        }
        return ResourceException.makeResponse(exception.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, ResourceErrorType.UNKNOWN, null);
    }
}

