package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.plugins.createcontent.BlueprintConstants;
import com.atlassian.confluence.plugins.createcontent.SpaceBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.SpaceBlueprintStateController;
import com.atlassian.confluence.plugins.createcontent.impl.SpaceBlueprint;
import com.atlassian.confluence.plugins.createcontent.model.BlueprintState;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import static com.atlassian.confluence.plugins.createcontent.BlueprintConstants.CREATE_SPACE_DIALOG_CONTENT_SECTION;

public class ListSpaceListBlueprintTemplatesContextProvider extends AbstractListBlueprintTemplatesContextProvider {
    private final ContextPathHolder contextPathHolder;
    private final I18nResolver i18nResolver;
    private final SpaceBlueprintStateController spaceBlueprintStateController;
    private final SpaceBlueprintManager spaceBlueprintManager;
    private final PermissionManager permissionManager;

    public ListSpaceListBlueprintTemplatesContextProvider(ContextPathHolder contextPathHolder, I18nResolver i18nResolver,
                                                          SpaceBlueprintStateController spaceBlueprintStateController, SpaceBlueprintManager spaceBlueprintManager, PermissionManager permissionManager) {
        this.contextPathHolder = contextPathHolder;
        this.i18nResolver = i18nResolver;
        this.spaceBlueprintStateController = spaceBlueprintStateController;
        this.spaceBlueprintManager = spaceBlueprintManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public Map<String, Object> getContextMap(final Map<String, Object> context) {
        final ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        final Map<UUID, BlueprintState> blueprintStateMap =
                spaceBlueprintStateController.getAllSpaceBlueprintState(CREATE_SPACE_DIALOG_CONTENT_SECTION, currentUser);
        final List<SpaceBlueprint> spaceBlueprints = spaceBlueprintManager.getAll();

        // Gets all blueprints to be displayed in the Admin page (enabled or disabled)
        final Collection<SpaceBlueprint> displayableBlueprints = getDisplayableBlueprints(spaceBlueprints, blueprintStateMap, false);
        final Collection<SpaceBlueprint> enabledBlueprints = getEnabledBlueprints(spaceBlueprints, blueprintStateMap);

        final Collection<SpaceBlueprint> nonSystemBlueprints = new ArrayList<SpaceBlueprint>();

        //Remove blank and personal space BPs from the list
        for (SpaceBlueprint displayableBlueprint : displayableBlueprints) {
            String moduleCompleteKey = displayableBlueprint.getModuleCompleteKey();

            if (!(moduleCompleteKey.equals(BlueprintConstants.MODULE_KEY_BLANK_SPACE) ||
                    moduleCompleteKey.equals(BlueprintConstants.MODULE_KEY_PERSONAL_SPACE))) {
                nonSystemBlueprints.add(displayableBlueprint);
            }
        }

        context.put("enabledBlueprints", enabledBlueprints);
        context.put("spaceBlueprints", nonSystemBlueprints);

        context.put("contextPath", contextPathHolder.getContextPath());
        context.put("i18nResolver", i18nResolver);

        boolean canEnableDisableModules = permissionManager.hasPermission(currentUser, Permission.ADMINISTER,
                (PermissionManager.TARGET_APPLICATION));
        context.put("canEnableDisableModules", canEnableDisableModules);

        return context;
    }
}
