package com.atlassian.confluence.plugins.createcontent.template;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.sal.api.message.I18nResolver;

import java.util.Map;

public class ListPluginTemplatesContextProvider implements ContextProvider {
    private final PluginPageTemplateHelper pluginPageTemplateHelper;
    private final ContextPathHolder contextPathHolder;
    private final I18nResolver i18nResolver;

    public ListPluginTemplatesContextProvider(PluginPageTemplateHelper pluginPageTemplateHelper,
                                              ContextPathHolder contextPathHolder, I18nResolver i18nResolver) {
        this.pluginPageTemplateHelper = pluginPageTemplateHelper;
        this.contextPathHolder = contextPathHolder;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public void init(Map<String, String> params) throws PluginParseException {
    }

    @Override
    public Map<String, Object> getContextMap(final Map<String, Object> context) {
        context.put("systemTemplates", pluginPageTemplateHelper.getSystemPageTemplates());
        context.put("contextPath", contextPathHolder.getContextPath());
        context.put("i18nResolver", i18nResolver);

        return context;
    }
}
