package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.spaces.Space;
import com.google.common.base.Function;

import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import static com.atlassian.confluence.util.GeneralUtil.htmlEncode;

@XmlRootElement
public class SpaceEntity {
    @XmlElement
    private String id;
    @XmlElement
    private String text;

    // JAXB
    private SpaceEntity() {
    }

    public SpaceEntity(Space space) {
        this(space.getKey(), space.getDisplayTitle());
    }

    SpaceEntity(String id, String text) {
        this.id = id;
        this.text = htmlEncode(text); // hack around xss vulnerability in jquery select2 plugin
    }

    public String getId() {
        return id;
    }

    public String getText() {
        return text;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SpaceEntity that = (SpaceEntity) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (text != null ? !text.equals(that.text) : that.text != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (text != null ? text.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return id;
    }

    public static Function<Space, SpaceEntity> spaceTransformer() {
        return new Function<Space, SpaceEntity>() {
            @Override
            public SpaceEntity apply(@Nullable Space space) {
                return new SpaceEntity(space);
            }
        };
    }
}
