package com.atlassian.confluence.plugins.createcontent.rest.entities;

import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintSpaceEntity;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

import java.util.Map;

/**
 * A REST Entity that represents the information needed to create a space from a Blueprint.
 */
public class CreateBlueprintSpaceRestEntity implements CreateBlueprintSpaceEntity {
    @JsonProperty
    private final String spaceKey;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final String description;
    @JsonProperty
    private final String permissions;
    @JsonProperty
    private final String spaceBlueprintId;
    @JsonProperty
    private final Map<String, Object> context;

    @JsonCreator
    public CreateBlueprintSpaceRestEntity(
            @JsonProperty("spaceKey") String spaceKey,
            @JsonProperty("name") String name,
            @JsonProperty("description") String description,
            @JsonProperty("permissions") String permissions,
            @JsonProperty("spaceBlueprintId") String spaceBlueprintId,
            @JsonProperty("context") Map<String, Object> context) {
        this.spaceKey = spaceKey;
        this.name = name;
        this.description = description;
        this.permissions = permissions;
        this.spaceBlueprintId = spaceBlueprintId;
        this.context = context;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getSpaceKey() {
        return spaceKey;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getPermissions() {
        return permissions;
    }

    @Override
    public String getSpaceBlueprintId() {
        return spaceBlueprintId;
    }

    public Map<String, Object> getContext() {
        return context;
    }
}
