package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.plugins.createcontent.services.UserStorageService;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON;

/**
 * REST endpoint to store discovery state.
 * For Quick create button we use "quick-create" key
 */
@Path("storage")
public class StorageResource {

    private UserStorageService userStorageService;

    public StorageResource(final UserStorageService userStorageService) {
        this.userStorageService = userStorageService;
    }

    /**
     * Add current user to storage
     *
     * @param key feature discovery key
     * @return Status
     */
    @PUT
    @Path("/{key}")
    @Consumes(APPLICATION_JSON)
    @Produces(APPLICATION_JSON)
    @RequiresXsrfCheck
    public Response storeKeyForCurrentUser(@PathParam("key") String key) {
        userStorageService.storeKeyForCurrentUser(key);
        return Response.ok(Response.Status.OK).build();
    }

    /**
     * Check current user is in storage or not
     *
     * @param key feature discovery key
     * @return true/false
     */
    @GET
    @Path("/{key}")
    public String isKeyStoredForCurrentUser(@PathParam("key") String key) {
        JSONObject result = new JSONObject();
        return result.put("isExist", userStorageService.isKeyStoredForCurrentUser(key)).toString();
    }

}
