package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.plugins.createcontent.rest.entities.SpaceEntity;

import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Collection;

import static javax.xml.bind.annotation.XmlAccessType.FIELD;

@XmlRootElement
@XmlAccessorType(FIELD)
public class SpaceResultsEntity {
    /**
     * The collection of spaces to be returned to the client
     */
    @XmlElement
    private Collection<SpaceEntity> spaces;

    /**
     * The limit on the number of results
     */
    @XmlElement
    private final int resultsLimit;

    /**
     * Whether or not the returned spaces collection has been truncated due to the results limit
     */
    @XmlElement
    private boolean resultsTruncated;

    public SpaceResultsEntity(Collection<SpaceEntity> spaces, int resultsLimit, boolean resultsTruncated) {
        this.spaces = spaces;
        this.resultsLimit = resultsLimit;
        this.resultsTruncated = resultsTruncated;
    }

    public Collection<SpaceEntity> getSpaces() {
        return spaces;
    }

    public boolean isResultsTruncated() {
        return resultsTruncated;
    }

    public int getResultsLimit() {
        return resultsLimit;
    }
}
