package com.atlassian.confluence.plugins.createcontent.rest;

import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.SpaceBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.extensions.BlueprintModuleDescriptor;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.PluginAccessor;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.MediaType;
import java.util.Collection;

/**
 * REST methods for administrating Blueprints at a high-level.
 *
 * @since 2.0
 */
@Path("/admin")
public class BlueprintsAdminResource extends AbstractRestResource {
    private final SpaceBlueprintManager spaceBlueprintManager;
    private final ContentBlueprintManager contentBlueprintManager;
    private final ContentTemplateRefManager contentTemplateManager;
    private final PluginAccessor pluginAccessor;

    public BlueprintsAdminResource(@Qualifier("spaceBlueprintManager") SpaceBlueprintManager spaceBlueprintManager,
                                   ContentBlueprintManager contentBlueprintManager, ContentTemplateRefManager contentTemplateManager,
                                   PermissionManager permissionManager, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager,
                                   PluginAccessor pluginAccessor) {
        super(permissionManager, spaceManager, spacePermissionManager);

        this.spaceBlueprintManager = spaceBlueprintManager;
        this.contentBlueprintManager = contentBlueprintManager;
        this.contentTemplateManager = contentTemplateManager;
        this.pluginAccessor = pluginAccessor;
    }

    @POST
    @Path("refreshAoTables")
    @Consumes({MediaType.APPLICATION_JSON})
    public int refreshAoTables() {
        checkAdminPermission();

        // Ordering here is important due to non-cascading AO deletes.
        spaceBlueprintManager.deleteAll();
        contentBlueprintManager.deleteAll();
        contentTemplateManager.deleteAll();

        int refreshed = refreshContentBlueprints();
        refreshed += spaceBlueprintManager.getAll().size(); // forces load from plugin system - better than Content BP

        return refreshed;
    }

    // Nasty, but Edu is refactoring the contentBlueprintManager so it should end up with a getAll-like method.
    private int refreshContentBlueprints() {
        final Collection<BlueprintModuleDescriptor> moduleDescriptors = pluginAccessor.getEnabledModuleDescriptorsByClass(BlueprintModuleDescriptor.class);
        for (BlueprintModuleDescriptor moduleDescriptor : moduleDescriptors) {
            contentBlueprintManager.getPluginBackedContentBlueprint(moduleDescriptor.getBlueprintKey(), null);
        }
        return moduleDescriptors.size();
    }
}
