package com.atlassian.confluence.plugins.createcontent.extensions;

import com.atlassian.confluence.plugin.module.PluginModuleFactory;
import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

public class SpaceCreationStepDescriptor extends AbstractModuleDescriptor<SpaceCreationStep> implements PluginModuleFactory<SpaceCreationStep> {
    private PluginModuleHolder<SpaceCreationStep> pluginModuleHolder = PluginModuleHolder.getInstance(this);

    public SpaceCreationStepDescriptor(final ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    @Override
    public SpaceCreationStep getModule() {
        return pluginModuleHolder.getModule();
    }

    public SpaceCreationStep createModule() {
        return moduleFactory.createModule(moduleClassName, this);
    }

    public void enabled() {
        super.enabled();
        pluginModuleHolder.enabled(getModuleClass());
    }

    public void disabled() {
        pluginModuleHolder.disabled();
        super.disabled();
    }
}
