package com.atlassian.confluence.plugins.createcontent.actions;

import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.pages.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Creates and saves a page from a Blueprint, bypassing the editor.
 * <p>
 * Plugin developers wishing to create a new Blueprint with a minimum of code and standard
 * behaviour can use this action to skip some boilerplate.
 *
 * @deprecated Use the "content-blueprint/create-content" REST endpoint instead. Since v2.0.
 */
@Deprecated
public final class CreateAndViewAction extends AbstractCreateBlueprintPageAction {
    private static final Logger log = LoggerFactory.getLogger(CreateAndViewAction.class);
    private Page indexPage;

    private final static String VIEW_INDEX_PAGE = "view-index";

    @Override
    public void validate() {
        try {
            setPage(populateBlueprintPage());
            validateDuplicatePageTitle();
            validatePageTitleAgainstIndexPageTitle();
        } catch (Exception e) {
            log.error("User tried to create a Blueprint that couldn't be loaded:", e);
            // Send them to the editor
            addActionError(getText("create.content.plugin.cannot.create.and.view"));
        }

        super.validate();
    }


    /**
     * Overridden because we need to generate the page title and content ourselves from the blueprint.
     */
    @Override
    public void createPage() throws XhtmlException {
        // do nothing -- the page has already been created and set inside validate()
    }

    /**
     * Overridden because we need to validate and create the index page before the page is added.
     */
    @Override
    protected String beforeAdd() throws Exception {
        String result = super.beforeAdd();
        if (!result.equals(SUCCESS))
            return result;

        final Page indexPage = getOrCreateIndexPage();
        this.indexPage = indexPage;
        // If the Blueprint page is not created from another page and the index page exists, it will be added under the Index page.
        // fromPage, rather than parentPage, is set by the Blueprint Wizard to keep track of the page's parent.
        Page parentPage = getFromPage();
        if (parentPage == null)
            parentPage = indexPage;
        if (parentPage != null)
            parentPage.addChild((Page) getPage());

        return SUCCESS;
    }

    /**
     * Overridden to send the create blueprint event after the page is created.
     */
    @Override
    protected String afterAdd() {
        String result = super.afterAdd();
        if (!result.equals(SUCCESS))
            return result;

        sendBlueprintPageCreateEvent((Page) getPage());

        //make sure this is last so we redirect to the index page
        if (getGoToIndexPage()) {
            return VIEW_INDEX_PAGE;
        }

        return SUCCESS;
    }

    public Page getIndexPage() {
        return indexPage;
    }
}
