package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.xwork.FlashScope;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;

import java.util.Map;
import java.util.UUID;

import static com.atlassian.confluence.plugins.createcontent.BlueprintConstants.INDEX_KEY;

/**
 * Adds the blueprint index key to the context
 */
public class MetadataProvider implements ContextProvider {
    private ContentBlueprintManager contentBlueprintManager;

    public MetadataProvider(final ContentBlueprintManager contentBlueprintManager) {
        this.contentBlueprintManager = contentBlueprintManager;
    }

    @Override
    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    @Override
    public Map<String, Object> getContextMap(Map<String, Object> stringObjectMap) {
        UUID id = (UUID) FlashScope.get(BlueprintManager.FIRST_BLUEPRINT_FOR_USER);
        String indexKey = contentBlueprintManager.getById(id).getIndexKey();
        stringObjectMap.put(INDEX_KEY, indexKey);
        return stringObjectMap;
    }
}
