package com.atlassian.confluence.plugins.createcontent.services;

import com.atlassian.confluence.plugins.createcontent.api.exceptions.BlueprintIllegalArgumentException;
import com.atlassian.confluence.spaces.Space;

import javax.annotation.Nonnull;
import java.util.Collection;

public interface PromotedTemplateService {
    /**
     * Promote a user created template
     *
     * @param templateId template id
     * @param spaceKey   space in which the template is to be promoted or demoted
     */
    void promoteTemplate(long templateId, @Nonnull String spaceKey)
            throws BlueprintIllegalArgumentException;

    /**
     * Un-promote a user created template
     *
     * @param templateId template id
     * @param spaceKey   space in which the template is to be promoted or demoted
     */
    void demoteTemplate(long templateId, @Nonnull String spaceKey)
            throws BlueprintIllegalArgumentException;

    /**
     * Gets all promoted templates for a space
     *
     * @param space space in which to get the promoted templates
     * @return a collection of promoted page template ids
     */
    Collection<Long> getPromotedTemplates(@Nonnull Space space);
}
