package com.atlassian.confluence.plugins.createcontent.exceptions;

import com.atlassian.confluence.plugins.createcontent.api.exceptions.ResourceErrorType;
import com.atlassian.plugin.ModuleDescriptor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Thrown when we expect to get a Blueprint plugin module but we end up getting a different type of module.
 */
public class ModuleNotBlueprintException extends AbstractTypedRuntimeException {
    public ModuleNotBlueprintException(@Nonnull final String message, @Nonnull final ResourceErrorType errorType, @Nullable final Object errorData) {
        super(message, errorType, errorData);
    }

    public ModuleNotBlueprintException(@Nonnull String moduleCompleteKey, @Nonnull ModuleDescriptor<?> moduleDescriptor, @Nonnull ResourceErrorType errorType, @Nullable Object errorData) {
        this("Module " + moduleCompleteKey + " is not a BlueprintModuleDescriptor. It is a " +
                (moduleDescriptor != null ? moduleDescriptor.getClass().getName() : "null"), errorType, errorData);
    }
}
