package com.atlassian.confluence.plugins.createcontent.concurrent;

public interface LazyInsertExecutor {
    /**
     * Do a non-lock read first, then if find no result, do a re-read and
     * insert inside a lock.
     * <p>
     * Most of the time (except for the first couple concurrent reads), the first
     * read succeeds and returns right away, so we don't need a lock.
     *
     * @param lockKey the key for acquiring lock. Different keys result in different locks (no contention).
     * @return either value returned by inserter#read() or value returned by inserter#insert()
     */
    <T> T lazyInsertAndRead(LazyInserter<T> inserter, String lockKey);
}
