package com.atlassian.confluence.plugins.createcontent.activeobjects;

import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.OneToMany;
import net.java.ao.Preload;
import net.java.ao.schema.Index;
import net.java.ao.schema.Indexes;
import net.java.ao.schema.Table;

import java.io.Serializable;

@Indexes({
        @Index(name = "ref_uuid_idx", methodNames = "getUuid")
})

@Preload
@Table("C_TEMPLATE_REF")
public interface ContentTemplateRefAo extends Serializable, PluginBackedBlueprintAo {
    long getTemplateId();

    void setTemplateId(long templateId);

    // When this ContentTemplateRef is representing a normal template
    @Accessor("CB_PARENT")
    ContentBlueprintAo getContentBlueprintParent();

    @Mutator("CB_PARENT")
    void setContentBlueprintParent(ContentBlueprintAo parent);

    // When this ContentTemplateRef is representing an index page
    @Accessor("CB_INDEX_PARENT")
    ContentBlueprintAo getContentBlueprintIndexParent();

    @Mutator("CB_INDEX_PARENT")
    void setContentBlueprintIndexParent(ContentBlueprintAo bp);

    ContentTemplateRefAo getParent();

    void setParent(ContentTemplateRefAo parent);

    /**
     * Return the child ContentTemplate refs that this Template has.
     */
    @OneToMany(reverse = "getParent")
    ContentTemplateRefAo[] getChildTemplateRefs();
}
