package com.atlassian.confluence.plugins.createcontent.actions;

import com.atlassian.confluence.plugins.createcontent.rest.SpaceResultsEntity;
import com.atlassian.confluence.plugins.createcontent.services.SpaceCollectionService;
import com.atlassian.confluence.web.UrlBuilder;
import com.opensymphony.xwork.Action;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;

import java.util.Collections;
import java.util.Map;

import static com.atlassian.confluence.security.SpacePermission.CREATEEDIT_PAGE_PERMISSION;
import static org.slf4j.LoggerFactory.getLogger;

public class CreatePageWithDefaultSpaceAction implements Action {

    private static final Logger log = getLogger(CreatePageWithDefaultSpaceAction.class);

    private final SpaceCollectionService spaceCollectionService;

    private String redirectUrl;

    public CreatePageWithDefaultSpaceAction(SpaceCollectionService spaceCollectionService) {
        this.spaceCollectionService = spaceCollectionService;
    }

    @Override
    public String execute() throws Exception {
        String spaceKey = getDefaultSpaceKey();

        UrlBuilder urlBuilder = new UrlBuilder("/pages/createpage.action");
        urlBuilder.add("spaceKey", spaceKey);
        urlBuilder.add("src", "quick-create");

        this.redirectUrl = urlBuilder.toUrl();
        return "success";
    }

    public String getRedirectUrl() {
        return redirectUrl;
    }

    private String getDefaultSpaceKey() {
        String spaceKey = "";
        try {
            Map<String, SpaceResultsEntity> spaces = spaceCollectionService.getSpaces(Collections.emptyList(), 1, 1, CREATEEDIT_PAGE_PERMISSION);
            if (!CollectionUtils.isEmpty(spaces.get("promotedSpaces").getSpaces())) {
                spaceKey = spaces.get("promotedSpaces").getSpaces().iterator().next().getId();
            } else if (!CollectionUtils.isEmpty(spaces.get("otherSpaces").getSpaces())) {
                spaceKey = spaces.get("otherSpaces").getSpaces().iterator().next().getId();
            }

            if (spaceKey.isEmpty()) {
                log.error("Couldn't find any space with create page permission. CreateContentCondition should have failed "
                        + "and QuickCreateUrlContextProvider.getContextMap() should not be called ");
            }
        } catch (Exception e) {
            log.error("Exception while calculating default space key. Catching to avoid bringing down the whole page.", e);
        }
        return spaceKey;
    }
}
