package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugins.createcontent.ContentTemplateRefManager;
import com.atlassian.confluence.plugins.createcontent.activeobjects.ContentBlueprintAo;
import com.atlassian.confluence.plugins.createcontent.activeobjects.ContentTemplateRefAo;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.UUID;

@Component("contentTemplateRefManager")
public class DefaultContentTemplateRefManager extends AbstractAoManager<ContentTemplateRef, ContentTemplateRefAo> implements ContentTemplateRefManager {
    @Autowired
    public DefaultContentTemplateRefManager(final @ComponentImport ActiveObjects activeObjects) {
        super(activeObjects, ContentTemplateRefAo.class);
    }

    @Nonnull
    @Override
    protected ContentTemplateRefAo internalCreateAo(@Nonnull ContentTemplateRef original) {
        final ContentTemplateRefAo ao = helperAoManager.createWithUuid();

        // No need to set parent here - it will have been done when initially saving the AO from the ContentTemplateModuleDescriptor.
        copyPropertiesIntoAo(ao, original, true);
        ao.save();

        return ao;
    }

    @Nonnull
    @Override
    protected ContentTemplateRefAo internalUpdateAo(@Nonnull final ContentTemplateRef object) {
        ContentTemplateRefAo ao = internalGetAoById(object.getId());
        if (ao == null) {
            String error = String.format("Content Template with UUID %s not found", object.getId());
            throw new IllegalStateException(error);
        }

        copyPropertiesIntoAo(ao, object, false);
        ao.save();

        return ao;
    }

    private void copyPropertiesIntoAo(@Nonnull ContentTemplateRefAo ao, @Nonnull ContentTemplateRef original, boolean isCreate) {
        if (isCreate) {
            ao.setPluginModuleKey(original.getModuleCompleteKey());
        }
        long templateId = original.getTemplateId();
        ao.setTemplateId(templateId);
        ao.setPluginClone(original.isPluginClone());
        ao.setI18nNameKey(original.getI18nNameKey());
        setParent(ao, original.getChildren());
    }

    @Override
    protected void internalDeleteAo(@Nonnull final ContentTemplateRefAo ao) {
        // FIXME: This doesn't take into account circular dependencies! (but none should appear, or lots of things will break before this)
        final ContentTemplateRefAo[] children = ao.getChildTemplateRefs();
        if (children != null) {
            for (ContentTemplateRefAo childAo : children) {
                internalDeleteAo(childAo);
            }
            activeObjects.delete(children);
        }
    }

    @Nonnull
    @Override
    protected ContentTemplateRef build(@Nonnull ContentTemplateRefAo ao) {
        // FIXME: Lame!
        boolean isIndex = true;
        ContentBlueprintAo parentAo = ao.getContentBlueprintIndexParent();
        if (parentAo == null) {
            parentAo = ao.getContentBlueprintParent();
            isIndex = false;
        }
        final ContentBlueprint parent = parentAo != null
                ? build(parentAo)
                : null;

        ContentTemplateRef ref = new ContentTemplateRef(
                UUID.fromString(ao.getUuid()),
                ao.getTemplateId(),
                ao.getPluginModuleKey(),
                ao.getI18nNameKey(),
                ao.isPluginClone(),
                parent);
        if (parent != null) {
            // FIXME: Still lame!
            if (isIndex)
                parent.setIndexPageTemplateRef(ref);
            else
                parent.setContentTemplateRefs(ImmutableList.of(ref));
        }
        final ContentTemplateRefAo[] childTemplateRefAos = ao.getChildTemplateRefs();
        for (ContentTemplateRefAo childTemplateRefAo : childTemplateRefAos) {
            // TODO: This retrieves ALL the children! Danger Will Robinson!
            ref.addChildTemplateRef(build(childTemplateRefAo));
        }

        return ref;
    }

    // FIXME: This needs to go!
    private ContentBlueprint build(ContentBlueprintAo ao) {
        ContentBlueprint result = new ContentBlueprint();
        result.setCreateResult(ao.getCreateResult());
        result.setModuleCompleteKey(ao.getPluginModuleKey());
        result.setI18nNameKey(ao.getI18nNameKey());
        result.setIndexKey(ao.getIndexKey());
        result.setSpaceKey(ao.getSpaceKey());

        return result;
    }

    /**
     * Updates the children of this object to recognize it as parent (and themselves as parent of their children, ad infinitum)
     */
    private void setParent(final ContentTemplateRefAo parent, final List<ContentTemplateRef> children) {
        for (ContentTemplateRef child : children) {
            ContentTemplateRefAo childAo = internalGetAoById(child.getId());
            if (childAo == null) {
                throw new RuntimeException("Template with UUID '" + child.getId() + "' unrecognized");
            }
            childAo.setParent(parent);
            childAo.save();

            setParent(childAo, child.getChildren());
        }
    }
}
