package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.plugin.ModuleCompleteKey;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.List;
import java.util.UUID;

public interface AoBackedManager<O, A> {
    /**
     * Find an object by its unique id.
     */
    @Nullable
    O getById(@Nonnull UUID id);

    /**
     * Find an object by its unique id.
     */
    @Nullable
    A getAoById(@Nonnull UUID id);

    /**
     * Find an object by its module complete key (only for plugin backed objects)
     */
    @Nullable
    O getCloneByModuleCompleteKey(@Nonnull ModuleCompleteKey moduleCompleteKey);

    /**
     * Find an object by its module complete key (only for plugin backed objects)
     */
    @Nonnull
    List<O> getNonClonesByModuleCompleteKey(@Nonnull ModuleCompleteKey moduleCompleteKey);

    /**
     * Gets all objects for this manager
     *
     * @return a list with all the objects for this manager
     */
    @Nonnull
    List<O> getAll();

    /**
     * Create a new Object of kind O and stores it on AO
     *
     * @return a new object based on the original one, but backed by AO
     */
    @Nonnull
    O create(@Nonnull O original);

    /**
     * Create a new Object of kind O and stores it on AO
     *
     * @return a new object based on the original one, but backed by AO
     */
    @Nonnull
    A createAo(@Nonnull O original);

    /**
     * Updates an existing object.
     */
    @Nonnull
    O update(@Nonnull O object);

    /**
     * Updates an existing object.
     */
    @Nonnull
    A updateAo(@Nonnull O object);

    /**
     * Deletes an existing object
     *
     * @return true if the object was deleted (i.e. it really existed and it was correctly deleted), false otherwise
     */
    boolean delete(@Nonnull UUID id);

    /**
     * Deletes an existing object using the AO reference
     */
    void delete(@Nonnull A object);

    /**
     * Deletes all objects. Normally only used in acceptance tests.
     *
     * @return the number of Blueprints deleted
     */
    int deleteAll();
}
