package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.event.events.admin.ImportFinishedEvent;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintCleaner;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * Clean up the old content blueprint templates on a site import
 * @since 10.1.0
 */
@Component
public class ImportFinishedListener {
    private final EventPublisher eventPublisher;
    private final ContentBlueprintCleaner contentBlueprintCleaner;

    @Autowired
    public ImportFinishedListener(
            final @ComponentImport EventPublisher eventPublisher,
            final ContentBlueprintCleaner contentBlueprintCleaner) {
        this.eventPublisher = eventPublisher;
        this.contentBlueprintCleaner = contentBlueprintCleaner;
    }

    @EventListener
    public void onImportFinishedEvent(ImportFinishedEvent event) {
        if (event.isSiteImport() && event.isOriginalEvent()) {
            contentBlueprintCleaner.cleanUp();
        }
    }

    @PreDestroy
    public void destroy() {
        eventPublisher.unregister(this);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        eventPublisher.register(this);
    }
}
