package com.atlassian.confluence.plugins.createcontent.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ContentTemplateRef extends PluginBackedBlueprint {
    private long templateId;
    private List<ContentTemplateRef> children = new ArrayList<>();
    private ContentBlueprint parent;

    private ContentTemplateRef() {
    }

    public ContentTemplateRef(
            final @Nullable UUID id,
            final long templateId,
            final @Nonnull String moduleCompleteKey,
            final @Nonnull String i18nNameKey,
            final boolean pluginClone,
            final @Nullable ContentBlueprint parent) {
        super(id, moduleCompleteKey, i18nNameKey, pluginClone);
        this.templateId = templateId;
        this.parent = parent;
    }

    @XmlElement
    public long getTemplateId() {
        return templateId;
    }

    public void setTemplateId(long templateId) {
        this.templateId = templateId;
    }

    @Nullable
    @XmlTransient
    public ContentBlueprint getParent() {
        return parent;
    }

    public void addChildTemplateRef(@Nonnull ContentTemplateRef child) {
        children.add(child);
    }

    @XmlElement
    @Nonnull
    public List<ContentTemplateRef> getChildren() {
        return children;
    }

    @Override
    @Nonnull
    public String toString() {
        return getTemplateId() + ":" + getModuleCompleteKey();
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ContentTemplateRef that = (ContentTemplateRef) o;

        // UUIDs are required and sufficient for equality (or we have something very wrong elsewhere...)
        return getId().equals(that.getId());
    }

    @Override
    public int hashCode() {
        return getId().hashCode();
    }
}
