package com.atlassian.confluence.plugins.createcontent.api.events;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.user.ConfluenceUser;

import java.util.Map;

/**
 * Fired when a Page is created from a Blueprint.
 *
 * @since 5.3
 */
@PublicApi
public class BlueprintPageCreateEvent extends com.atlassian.confluence.plugins.createcontent.events.BlueprintPageCreateEvent {
    /**
     * @param src     the object that created the Blueprint Page
     * @param page    the Page created
     * @param creator the user that created the Blueprint
     * @param context the context in which the Blueprint page was created, including Wizard and Provider data.
     */
    public BlueprintPageCreateEvent(Object src, Page page, ContentBlueprint blueprint, ConfluenceUser creator, Map<String, Object> context) {
        // Until the deprecated non-api-package version of this class is removed, this class MUST be a subclass of the
        // other event so that event listeners for the old event will pick this new one up.
        super(src, page, blueprint, creator, context);
    }
}