package com.atlassian.confluence.plugins.createcontent;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugins.createcontent.impl.PluginBackedBlueprint;
import com.atlassian.confluence.plugins.createcontent.model.BlueprintState;
import com.atlassian.confluence.plugins.createcontent.template.PageTemplateGrouper;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.google.common.collect.ImmutableMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@Component
public class BandanaBlueprintStateController extends AbstractBandanaBlueprintStateController implements BlueprintStateController {
    private static final String DISABLED_BLUEPRINT_ITEMS = "com.atlassian.confluence.blueprints.disabled";
    private final ContentBlueprintManager contentBlueprintManager;
    private final PageTemplateGrouper pageTemplateGrouper;

    @Autowired
    public BandanaBlueprintStateController(
            @ComponentImport BandanaManager bandanaManager,
            ContentBlueprintManager contentBlueprintManager,
            @ComponentImport WebInterfaceManager webInterfaceManager,
            PageTemplateGrouper pageTemplateGrouper,
            @ComponentImport PluginAccessor pluginAccessor) {
        super(bandanaManager, webInterfaceManager, pluginAccessor);
        this.pageTemplateGrouper = pageTemplateGrouper;
        this.contentBlueprintManager = contentBlueprintManager;
    }

    @Override
    public void enableBlueprint(UUID blueprintId, Space space) {
        enableBlueprint(blueprintId, space, DISABLED_BLUEPRINT_ITEMS);
    }

    @Override
    public void disableBlueprint(UUID blueprintId, Space space) {
        disableBlueprint(blueprintId, space, DISABLED_BLUEPRINT_ITEMS);
    }

    @Override
    public void disableBlueprints(Set<UUID> blueprintIds, Space space) {
        disableBlueprints(blueprintIds, space, DISABLED_BLUEPRINT_ITEMS);
    }

    @Override
    public Set<UUID> getDisabledBlueprintIds(Space space) {
        return getDisabledBlueprintIds(space, DISABLED_BLUEPRINT_ITEMS);
    }

    @Override
    public Set<String> getDisabledBlueprintModuleCompleteKeys(Space space) {
        return getDisabledSpaceBlueprintModuleCompleteKeys(space, DISABLED_BLUEPRINT_ITEMS, contentBlueprintManager);
    }

    public Map<UUID, BlueprintState> getAllContentBlueprintState(@Nonnull String section, @Nullable ConfluenceUser user, @Nullable Space space) {
        final Collection<? extends PluginBackedBlueprint> blueprints = pageTemplateGrouper.getSpaceContentBlueprints(space);

        Map<UUID, BlueprintState> blueprintStateMap = buildBlueprintStateMap(section, user, space, DISABLED_BLUEPRINT_ITEMS, blueprints);

        blueprintStateMap.put(BlueprintConstants.BLANK_PAGE_BLUEPRINT.getId(), BlueprintState.FULLY_ENABLED);
        blueprintStateMap.put(BlueprintConstants.BLOG_POST_BLUEPRINT.getId(), BlueprintState.FULLY_ENABLED);

        return ImmutableMap.copyOf(blueprintStateMap);
    }

}
