/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.impl;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.notifications.CachedContentFinder;
import com.atlassian.confluence.notifications.NotificationContentCacheKey;
import com.atlassian.confluence.notifications.content.CommonContentExpansions;
import com.atlassian.confluence.notifications.content.impl.ContentCacheLoader;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettingsBuilder;
import com.atlassian.vcache.VCacheFactory;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.Locale;
import java.util.UUID;

public class DefaultCachedContentFinder
implements CachedContentFinder {
    @VisibleForTesting
    static final int APPROX_LOCALES_INSTALLED = 5;
    @VisibleForTesting
    static final String ANON_RENDER_CACHE_ENABLED = "notification.plugin.caching.enabled";
    static final String CACHE_NAME = DefaultCachedContentFinder.class.getName();
    private final ContentService contentService;
    private final JvmCache<NotificationContentCacheKey, Option<Content>> contentBodyCache;
    private final DarkFeatureManager darkFeatureManager;
    private final ContentCacheLoader contentCacheLoader;

    public DefaultCachedContentFinder(ContentService contentService, VCacheFactory cacheFactory, ContentCacheLoader contentCacheLoader, DarkFeatureManager darkFeatureManager) {
        this.contentService = contentService;
        this.darkFeatureManager = darkFeatureManager;
        this.contentBodyCache = DefaultCachedContentFinder.createCache(cacheFactory);
        this.contentCacheLoader = contentCacheLoader;
    }

    private static JvmCache<NotificationContentCacheKey, Option<Content>> createCache(VCacheFactory cacheFactory) {
        return cacheFactory.getJvmCache(CACHE_NAME, new JvmCacheSettingsBuilder().defaultTtl(Duration.ofSeconds(60L)).maxEntries(Integer.getInteger("notifications.sender.thread.count", 3) * 5).build());
    }

    public Option<Content> getContent(UUID notificationId, ModuleCompleteKey key, Locale locale, ContentId contentId, Expansion ... expansions) {
        if (this.isCachingEnabled()) {
            Option permissionQuery = this.contentService.find(new Expansion[0]).withId(contentId).fetchOne();
            if (permissionQuery.isDefined()) {
                NotificationContentCacheKey cacheKey = new NotificationContentCacheKey(notificationId, key, locale, contentId, expansions);
                return (Option)this.contentBodyCache.get((Object)cacheKey, () -> this.contentCacheLoader.load(cacheKey));
            }
            return permissionQuery;
        }
        return this.contentService.find(expansions).withId(contentId).fetchOne();
    }

    public Expansion exportBody() {
        if (this.isCachingEnabled()) {
            return CommonContentExpansions.ANON_EXPORT_BODY;
        }
        return CommonContentExpansions.EXPORT_BODY;
    }

    public ContentRepresentation exportRepresentation() {
        if (this.isCachingEnabled()) {
            return ContentRepresentation.ANONYMOUS_EXPORT_VIEW;
        }
        return ContentRepresentation.EXPORT_VIEW;
    }

    private boolean isCachingEnabled() {
        return this.darkFeatureManager.isFeatureEnabledForAllUsers(ANON_RENDER_CACHE_ENABLED);
    }
}

