require(["internal/browser-metrics", "jquery"], function (metrics, $) {
    function measure() {
        var contentType = AJS.Meta.get('content-type');
        var action = AJS.Meta.getBoolean('new-page') ? "create" : "edit";
        var $body = $('body');
        var isAnEditorPage = $body.hasClass('edit') || $body.hasClass('create');

        // Don't try to record this transition if we are not on the edit page directly
        if (isAnEditorPage && contentType && action) {
            // We avoid triggering an event when shared drafts are enabled but we don't have Synchrony
            //   this is a limited mode for Confluence to run in as a last resort, and shouldn't affect Apdex scores.
            if (AJS.Meta.getBoolean('collaborative-content')) {
                var metricKey = "confluence." + contentType + "." + action + ".collaborative.view";
                metrics.start({
                    key: metricKey,
                    isInitial: true
                });
                AJS.bind("rte-collab-ready", function() {
                    metrics.end({
                        key:  metricKey
                    });
                    metrics.start({
                        key: metricKey + ".connected"
                    });
                });
                AJS.bind("synchrony.connected", function() {
                    metrics.end({
                        key:  metricKey + ".connected"
                    });
                });
            } else if (!AJS.Meta.getBoolean('collaborative-content')) {
                metrics.start({
                    key: "confluence." + contentType + "." + action + ".view",
                    ready: ".active-richtext",
                    isInitial: true
                });
            }
        }

    }

    $(measure);
});