(function() {

    var BrowserMetrics = window.BrowserMetrics || {};

    if (BrowserMetrics.isEnabled()) {
        // TODO: copied from browser-metrics.js, need to share properly
        var VERSION = 5;

        var THRESHOLD = 12000; // Timings above this threshold will be clipped to an 'x' value.

        var round2 = function(value) {
            return Math.round(value * 100) / 100;
        };

        var initEvents = function(global) {
            var metrics = {};

            function time() {
                return global.performance && global.performance.now ? global.performance.now() : new Date().getTime();
            }

            function isObject(obj) {
                return obj === Object(obj);
            }

            function toFullEventName(key) {
                if (isObject(key)) {
                    return key.eventName + "." + key.eventType;
                } else {
                    return key;
                }
            }

            function toEventName(key) {
                if (isObject(key)) {
                    return key.eventName;
                } else {
                    return key;
                }
            }

            function toEventType(key) {
                if (isObject(key)) {
                    return key.eventType;
                } else {
                    return "";
                }
            }

            function start(key) {
                var fullEventName = toFullEventName(key);
                metrics[fullEventName] = time();
            }

            function end(key, suffix) {
                var fullEventName = toFullEventName(key);

                if (!metrics[fullEventName]) {
                    throw("Error logging browser metrics event end: no start event for key '" + fullEventName + "'");
                }

                var value = time() - metrics[fullEventName];
                metrics[fullEventName] = null;

                var eventName = toEventName(key),
                    eventType = toEventType(key);

                var name = 'browser.metrics.e.' + eventName + (suffix ? '.' + suffix : ''),
                    data = {
                        version: VERSION,
                        value: value > THRESHOLD ? 'x' : Math.ceil((value) / 100),
                        rawValue: round2(value),
                        eventType: eventType
                    };

                global.AJS.Analytics ? global.AJS.Analytics.triggerPrivacyPolicySafeEvent(name, data) : global.AJS.trigger('analyticsEvent', { name: name, data: data });
            }

            return {
                start: start,
                end: end
            };
        };

        if (!window.ATL_PERF) {
            window.ATL_PERF = {};
        }
        window.ATL_PERF.initEvents = initEvents;
    }
}());
