/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.auditing.listeners;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditResource;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.audit.StandardAuditResourceTypes;
import com.atlassian.confluence.plugins.auditing.listeners.AbstractEventListener;
import com.atlassian.confluence.plugins.auditing.utils.AuditCategories;
import com.atlassian.confluence.plugins.auditing.utils.MessageKeyBuilder;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.oauth.event.AccessTokenAddedEvent;
import com.atlassian.oauth.event.AccessTokenRemovedEvent;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import java.util.Optional;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent(value="oauthTokenEventsListener")
public class OAuthTokenEventsListener
extends AbstractEventListener {
    static final String OATH_AUDIT_SUMMARY_TOKEN_ADDED = MessageKeyBuilder.buildSummaryTextKey("oauth.token.added");
    static final String OATH_AUDIT_SUMMARY_TOKEN_REMOVED = MessageKeyBuilder.buildSummaryTextKey("oauth.token.removed");
    static final String OATH_AUDIT_VALUE_CONSUMER_NAME = MessageKeyBuilder.buildChangedValueTextKey("oauth.consumer.name");
    private final ServiceProviderConsumerStore serviceProviderConsumerStore;
    private final StandardAuditResourceTypes standardAuditResourceTypes;
    private final UserAccessor userAccessor;

    @Autowired
    public OAuthTokenEventsListener(AuditService auditBroker, EventListenerRegistrar eventListenerRegistrar, @ComponentImport I18nResolver i18nResolver, @ComponentImport LocaleResolver localeResolver, @ComponentImport ServiceProviderConsumerStore serviceProviderConsumerStore, @ConfluenceImport StandardAuditResourceTypes standardAuditResourceTypes, @ConfluenceImport UserAccessor userAccessor) {
        super(auditBroker, eventListenerRegistrar, i18nResolver, localeResolver);
        this.serviceProviderConsumerStore = serviceProviderConsumerStore;
        this.standardAuditResourceTypes = standardAuditResourceTypes;
        this.userAccessor = userAccessor;
    }

    @EventListener
    public void onTokenAddedEvent(AccessTokenAddedEvent event) {
        this.saveToBroker(() -> {
            AuditEvent.Builder auditEventBuilder = AuditEvent.builder((AuditType)this.buildOAuthAuditType(OATH_AUDIT_SUMMARY_TOKEN_ADDED));
            this.buildConsumerChangedValue(event.getConsumerKey(), true).ifPresent(arg_0 -> ((AuditEvent.Builder)auditEventBuilder).changedValue(arg_0));
            this.buildAffectedUserResource(event.getUsername()).ifPresent(arg_0 -> ((AuditEvent.Builder)auditEventBuilder).affectedObject(arg_0));
            return auditEventBuilder.build();
        });
    }

    @EventListener
    public void onTokenRemovedEvent(AccessTokenRemovedEvent event) {
        this.saveToBroker(() -> {
            AuditEvent.Builder auditEventBuilder = AuditEvent.builder((AuditType)this.buildOAuthAuditType(OATH_AUDIT_SUMMARY_TOKEN_REMOVED));
            this.buildConsumerChangedValue(event.getConsumerKey(), false).ifPresent(arg_0 -> ((AuditEvent.Builder)auditEventBuilder).changedValue(arg_0));
            this.buildAffectedUserResource(event.getUsername()).ifPresent(arg_0 -> ((AuditEvent.Builder)auditEventBuilder).affectedObject(arg_0));
            return auditEventBuilder.build();
        });
    }

    private AuditType buildOAuthAuditType(String key) {
        return new AuditType(CoverageArea.SECURITY, this.translate(AuditCategories.AUTH_CATEGORY), this.translate(key), CoverageLevel.ADVANCED);
    }

    private Optional<AuditResource> buildAffectedUserResource(@Nullable String username) {
        return Optional.ofNullable(username).map(arg_0 -> ((UserAccessor)this.userAccessor).getUserByName(arg_0)).map(user -> AuditResource.builder((String)user.getFullName(), (String)this.standardAuditResourceTypes.user()).id(user.getKey().getStringValue()).build());
    }

    private Optional<ChangedValue> buildConsumerChangedValue(@Nullable String consumerKey, boolean isAdded) {
        return Optional.ofNullable(consumerKey).map(arg_0 -> ((ServiceProviderConsumerStore)this.serviceProviderConsumerStore).get(arg_0)).map(consumer -> isAdded ? new ChangedValue(this.translate(OATH_AUDIT_VALUE_CONSUMER_NAME), null, consumer.getName()) : new ChangedValue(this.translate(OATH_AUDIT_VALUE_CONSUMER_NAME), consumer.getName(), null));
    }
}

