/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.TesterConfiguration;
import com.atlassian.confluence.plugin.functest.helper.HelperFactory;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapServiceServiceLocator;
import com.atlassian.confluence.plugin.functest.util.ClasspathResourceUtil;
import com.atlassian.confluence.plugin.functest.util.ConfluenceBuildUtil;
import com.atlassian.confluence.plugin.functest.util.PluginMetadataUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.xml.rpc.ServiceException;
import junit.framework.Assert;
import net.sourceforge.jwebunit.api.ITestingEngine;
import net.sourceforge.jwebunit.junit.WebTester;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.w3c.dom.Document;

public class JWebUnitConfluenceWebTester
extends WebTester
implements ConfluenceWebTester {
    private static final Logger LOG = Logger.getLogger(JWebUnitConfluenceWebTester.class);
    private static final Set<String> KEYS_OF_PLUGINS_INSTALLED_BY_TEST_LIBRARY = new HashSet<String>();
    private final TesterConfiguration testerConfiguration;
    private String currentUserName;
    private String currentPassword;
    private String licenseString;

    public JWebUnitConfluenceWebTester(TesterConfiguration testerConfiguration) {
        this.testerConfiguration = testerConfiguration;
        this.setCurrentUserName(this.testerConfiguration.getAdminUserName());
        this.setCurrentPassword(this.testerConfiguration.getAdminPassword());
        this.getTestContext().setBaseUrl(this.testerConfiguration.getBaseUrl());
        this.setScriptingEnabled(false);
    }

    public String getBaseUrl() {
        return this.testerConfiguration.getBaseUrl();
    }

    public String getAdminUserName() {
        return this.testerConfiguration.getAdminUserName();
    }

    public String getAdminPassword() {
        return this.testerConfiguration.getAdminPassword();
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public void setCurrentUserName(String currentUserName) {
        this.currentUserName = currentUserName;
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public void login(String username, String password) {
        this.setCurrentUserName(username);
        this.setCurrentPassword(password);
        this.login();
    }

    public void login() {
        this.gotoPage("/login.action");
        this.assertTextNotPresent("You are currently logged in");
        this.setWorkingForm("loginform");
        this.setTextField("os_username", this.getCurrentUserName());
        this.setTextField("os_password", this.getCurrentPassword());
        this.submit("login");
        this.assertLinkPresentWithText("Log Out");
    }

    public void logout() {
        this.gotoPage("/logout.action");
        this.assertTextPresent("You have been successfully logged out");
    }

    public XmlRpcClient getXmlRpcClient() throws MalformedURLException {
        return new XmlRpcClient(this.getBaseUrl() + "/rpc/xmlrpc");
    }

    public ConfluenceSoapService getConfluenceSoapService() throws MalformedURLException, ServiceException {
        ConfluenceSoapServiceServiceLocator confluenceSoapServiceServiceLocator = new ConfluenceSoapServiceServiceLocator();
        return confluenceSoapServiceServiceLocator.getConfluenceserviceV1(new URL(this.getBaseUrl() + "/rpc/soap-axis/confluenceservice-v1?wsdl"));
    }

    public String loginToXmlRpcService(String userName, String password) throws XmlRpcException, IOException {
        XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
        return (String)xmlRpcClient.execute("confluence1.login", new Vector<String>(Arrays.asList(userName, password)));
    }

    public void logoutFromXmlRpcService(String authenticationToken) {
        if (StringUtils.isNotBlank((String)authenticationToken)) {
            try {
                XmlRpcClient xmlRpcClient = this.getXmlRpcClient();
                xmlRpcClient.execute("confluence1.logout", new Vector<String>(Arrays.asList(authenticationToken)));
            }
            catch (MalformedURLException mUrlE) {
                LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
            }
            catch (XmlRpcException xmlRpcE) {
                LOG.error((Object)"Service request denied.", (Throwable)xmlRpcE);
            }
            catch (RemoteException re) {
                LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
            }
            catch (IOException ioe) {
                LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
            }
        }
    }

    public String loginToXmlRPcService() throws XmlRpcException, IOException {
        return this.loginToXmlRpcService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    public String loginToSoapService(String userName, String password) throws MalformedURLException, ServiceException, RemoteException {
        ConfluenceSoapService confluenceSoapService = this.getConfluenceSoapService();
        return StringUtils.isNotBlank((String)userName) ? confluenceSoapService.login(userName, password) : null;
    }

    public String loginToSoapService() throws MalformedURLException, ServiceException, RemoteException {
        return this.loginToSoapService(this.getCurrentUserName(), this.getCurrentPassword());
    }

    public void logoutFromSoapService(String authenticationToken) {
        try {
            if (null != authenticationToken) {
                this.getConfluenceSoapService().logout(authenticationToken);
            }
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLicense() throws IOException {
        String licenseString = this.getLicenseString();
        if (StringUtils.isNotBlank((String)licenseString)) {
            try {
                Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/console.action"));
                this.clickLinkWithText("License Details");
                this.setWorkingForm("updateLicenseForm");
                this.setTextField("licenseString", licenseString);
                this.submit("update");
                this.assertTextNotPresent("License string is too short");
                this.assertTextNotPresent("License was not valid");
            }
            finally {
                this.dropEscalatedPrivileges();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLicense() {
        try {
            Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/refreshlicensing.action"));
        }
        finally {
            this.dropEscalatedPrivileges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installTestLibrary() {
        File testLibraryJar = this.testerConfiguration.getTestLibraryJar();
        if (null != testLibraryJar && testLibraryJar.isFile()) {
            try {
                Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/console.action"));
                String pluginKey = PluginMetadataUtil.getPluginKey(PluginMetadataUtil.getPluginDescriptorDom(testLibraryJar));
                if (!this.isPluginInstalled(pluginKey)) {
                    LOG.info((Object)("Installing test library with key " + pluginKey));
                    this.installPlugin(testLibraryJar);
                } else {
                    LOG.info((Object)"Plugin test library already installed. Skipping installation.");
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Unable to determine plugin key from " + testLibraryJar + SystemUtils.LINE_SEPARATOR + ExceptionUtils.getFullStackTrace((Throwable)e)));
            }
            finally {
                this.dropEscalatedPrivileges();
            }
        }
    }

    public void installPlugin() {
        File pluginJar = this.testerConfiguration.getPluginJar();
        if (this.testerConfiguration.isInstallPlugin() && null != pluginJar) {
            this.installPlugin(pluginJar);
        }
    }

    public void installPlugin(File pluginJar) {
        block5: {
            if (null != pluginJar && pluginJar.isFile()) {
                try {
                    Document pluginDescDom = PluginMetadataUtil.getPluginDescriptorDom(pluginJar);
                    String pluginKey = PluginMetadataUtil.getPluginKey(pluginDescDom);
                    String pluginName = PluginMetadataUtil.getPluginName(pluginDescDom);
                    if (!this.hasTestLibraryInstalledPlugin(pluginKey)) {
                        LOG.info((Object)("Installing plugin \"" + pluginName + "\" with key " + pluginKey));
                        this.installPluginInternal(pluginJar);
                        this.markPluginInstalledByTestLibrary(pluginKey);
                        break block5;
                    }
                    LOG.info((Object)("Plugin \"" + pluginName + "\" already installed. Skipping installation."));
                }
                catch (Exception e) {
                    Assert.fail((String)("Unable to determine plugin key from " + pluginJar + SystemUtils.LINE_SEPARATOR + ExceptionUtils.getFullStackTrace((Throwable)e)));
                }
            } else {
                LOG.warn((Object)("Invalid plugin JAR (" + pluginJar + ") specified for install. Skipping"));
            }
        }
    }

    private boolean isPluginInstalled(String pluginKey) {
        if (this.isConfluence210AndBelow()) {
            this.gotoPage("/admin/plugins.action?pluginKey=" + pluginKey);
        } else {
            this.gotoPage("/admin/viewplugins.action?pluginKey=" + pluginKey);
        }
        ITestingEngine webDialog = this.getTestingEngine();
        return webDialog.hasElementByXPath("//a[text()='Enable plugin']") || webDialog.hasElementByXPath("//a[text()='Disable plugin']");
    }

    private boolean isConfluence210AndBelow() {
        return ConfluenceBuildUtil.getBuildNumber() < 1600;
    }

    private boolean hasTestLibraryInstalledPlugin(String pluginKey) {
        return KEYS_OF_PLUGINS_INSTALLED_BY_TEST_LIBRARY.contains(pluginKey);
    }

    private void markPluginInstalledByTestLibrary(String pluginKey) {
        KEYS_OF_PLUGINS_INSTALLED_BY_TEST_LIBRARY.add(pluginKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installPluginInternal(File pluginJar) {
        try {
            Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/viewplugins.action"));
            this.assertTextPresent("Manage Plugins");
            this.setWorkingForm("plugin-upload");
            this.setTextField("file_0", pluginJar.getAbsolutePath());
            this.submit("confirm");
            String pluginName = PluginMetadataUtil.getPluginName(PluginMetadataUtil.getPluginDescriptorDom(pluginJar));
            this.assertLinkPresentWithText(pluginName);
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to get plugin name from plugin JAR at " + pluginJar + "\n" + ExceptionUtils.getFullStackTrace((Throwable)e)));
        }
        finally {
            this.dropEscalatedPrivileges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreData() {
        File configuredSiteExport = this.testerConfiguration.getSiteBackupZip();
        File siteExportZip = null;
        try {
            if (null != configuredSiteExport) {
                this.restoreData(configuredSiteExport);
            } else {
                siteExportZip = ClasspathResourceUtil.getClassPathResourceAsTempFile("site-export.zip", this.getClass().getClassLoader(), ".zip");
                if (null != siteExportZip) {
                    this.restoreData(siteExportZip);
                }
            }
        }
        catch (IOException ioe) {
            Assert.fail((String)("Unable to restore class path site-export.zip: " + ioe.getMessage()));
        }
        finally {
            if (null != siteExportZip && siteExportZip.exists()) {
                Assert.assertTrue((String)("Unable to delete " + siteExportZip), (boolean)siteExportZip.delete());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreData(File exportZip) {
        if (null != exportZip && exportZip.isFile()) {
            try {
                String destination = "/admin/backup.action?synchronous=true";
                this.gotoPageWithEscalatedPrivileges(destination);
                this.assertTextPresent("Restore Confluence Data");
                this.setWorkingForm(2);
                this.setTextField("file", exportZip.getAbsolutePath());
                this.submit();
                this.gotoPage("/admin/editgeneralconfig.action");
                this.setWorkingForm("editgeneralconfig");
                this.setTextField("domainName", this.getBaseUrl());
                this.submit("confirm");
                HelperFactory.createIndexHelper(this).update();
            }
            finally {
                this.dropEscalatedPrivileges();
            }
        } else {
            LOG.warn((Object)("Unable to find export file: " + exportZip + ". Skipping data restoration."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCaches() {
        try {
            Assert.assertTrue((boolean)this.gotoPageWithEscalatedPrivileges("/admin/console.action"));
            this.clickLinkWithText("Cache Statistics");
            this.clickLinkWithText("Flush all");
        }
        finally {
            this.dropEscalatedPrivileges();
        }
    }

    public String getLicenseString() {
        return StringUtils.defaultIfEmpty((String)this.licenseString, (String)this.testerConfiguration.getLicense());
    }

    public void setLicenseString(String licenseString) {
        this.licenseString = licenseString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String assertXsrfStatusCode(String resourcePath) {
        StringBuilder urlWithOsAuthTypeReplacedBuilder = new StringBuilder(this.getBaseUrl()).append(resourcePath.replaceAll("(.*[?&])(os_authType=\\w*)(.*)", "$1os_authType=basic$3"));
        if (urlWithOsAuthTypeReplacedBuilder.indexOf("os_authType") < 0) {
            urlWithOsAuthTypeReplacedBuilder.append(urlWithOsAuthTypeReplacedBuilder.indexOf("?") < 0 ? (char)'?' : '&').append("os_authType=basic");
        }
        HttpClient client = new HttpClient();
        GetMethod httpGet = new GetMethod(urlWithOsAuthTypeReplacedBuilder.toString());
        try {
            client.getState().setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.getCurrentUserName(), this.getCurrentPassword()));
            httpGet.setDoAuthentication(true);
            Assert.assertEquals((int)403, (int)client.executeMethod((HttpMethod)httpGet));
            String string = httpGet.getResponseBodyAsString();
            return string;
        }
        catch (IOException ioe) {
            LOG.error((Object)("Error getting HTTP resource " + urlWithOsAuthTypeReplacedBuilder), (Throwable)ioe);
            String string = null;
            return string;
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    public void assertResourceXsrfProtected(String resourcePath) {
        Assert.assertFalse((String)("No body text returned for " + resourcePath), (boolean)StringUtils.isBlank((String)this.assertXsrfStatusCode(resourcePath)));
    }

    public void assertXsrfTokenNotPresentFailure(String resourcePath) {
        Assert.assertTrue((this.assertXsrfStatusCode(resourcePath).indexOf("a required security token was not present") >= 0 ? 1 : 0) != 0);
    }

    public void assertXsrfTokenNotValidFailure(String resourcePath) {
        Assert.assertTrue((this.assertXsrfStatusCode(resourcePath).indexOf("Your session has expired. You may need to re-submit the form or reload the page.") >= 0 ? 1 : 0) != 0);
    }

    public boolean gotoPageWithEscalatedPrivileges(String destination) {
        return this.gotoPageWithEscalatedPrivileges(destination, "UTF-8");
    }

    public boolean gotoPageWithEscalatedPrivileges(String destination, String urlEncoding) {
        if (ConfluenceBuildUtil.containsSudoFeature() && !this.getDialog().hasElementByXPath("//*[@id='confluence-message-websudo-message']")) {
            try {
                this.gotoPage("/authenticate.action?destination=" + URLEncoder.encode(destination, urlEncoding));
                this.setWorkingForm("authenticateform");
                this.setTextField("password", this.getCurrentPassword());
                this.submit("authenticate");
            }
            catch (UnsupportedEncodingException uee) {
                LOG.error((Object)("Unable to URL encode " + destination + " with " + urlEncoding), (Throwable)uee);
                return false;
            }
        } else {
            this.gotoPage(destination);
        }
        return true;
    }

    public void dropEscalatedPrivileges() {
        if (ConfluenceBuildUtil.containsSudoFeature() && this.getDialog().hasElementByXPath("//*[@id='confluence-message-websudo-message']")) {
            this.gotoPage("/dropauthentication.action");
        }
    }
}

