/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.functest.helper;

import com.atlassian.confluence.plugin.functest.ConfluenceWebTester;
import com.atlassian.confluence.plugin.functest.helper.AbstractHelper;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.ConfluenceSoapService;
import com.atlassian.confluence.plugin.functest.remote.soap.stub.RemoteUser;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class UserHelper
extends AbstractHelper {
    private static final Logger LOG = Logger.getLogger((Class)UserHelper.class);
    private String name;
    private String fullName;
    private String emailAddress;
    private String password;
    private List groups;

    public UserHelper(ConfluenceWebTester confluenceWebTester, String name) {
        super(confluenceWebTester);
        this.setName(name);
        this.setGroups(new ArrayList());
    }

    public UserHelper(ConfluenceWebTester confluenceWebTester) {
        this(confluenceWebTester, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List getGroups() {
        return this.groups;
    }

    public void setGroups(List groups) {
        this.groups = groups;
    }

    protected RemoteUser toRemoteUser() {
        RemoteUser remoteUser = new RemoteUser();
        remoteUser.setName(this.getName());
        remoteUser.setFullname(this.getFullName());
        remoteUser.setEmail(this.getEmailAddress());
        return remoteUser;
    }

    protected void populateHelper(RemoteUser remoteUser) {
        this.setName(remoteUser.getName());
        this.setFullName(remoteUser.getFullname());
        this.setEmailAddress(remoteUser.getEmail());
    }

    protected void addUserToGroups(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws RemoteException {
        Iterator i = this.getGroups().iterator();
        while (i.hasNext()) {
            confluenceSoapService.addUserToGroup(soapSessionToken, this.getName(), (String)i.next());
        }
    }

    protected void removeUserGroups(String soapSessionToken, ConfluenceSoapService confluenceSoapService) throws RemoteException {
        Iterator<String> i = Arrays.asList(confluenceSoapService.getUserGroups(soapSessionToken, this.getName())).iterator();
        while (i.hasNext()) {
            confluenceSoapService.removeUserFromGroup(soapSessionToken, this.getName(), i.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            confluenceSoapService.addUser(soapSessionToken, this.toRemoteUser(), this.getPassword());
            this.addUserToGroups(soapSessionToken, confluenceSoapService);
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePassword() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = confluenceSoapService.changeUserPassword(soapSessionToken, this.getName(), this.getPassword());
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            this.populateHelper(confluenceSoapService.getUser(soapSessionToken, this.getName()));
            this.setGroups(Arrays.asList(confluenceSoapService.getUserGroups(soapSessionToken, this.getName())));
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            confluenceSoapService.editUser(soapSessionToken, this.toRemoteUser());
            this.removeUserGroups(soapSessionToken, confluenceSoapService);
            this.addUserToGroups(soapSessionToken, confluenceSoapService);
            boolean bl = true;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = confluenceSoapService.removeUser(soapSessionToken, this.getName());
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            LOG.error((Object)"Invalid RPC URL specified.", (Throwable)mUrlE);
        }
        catch (ServiceException se) {
            LOG.error((Object)"Service request denied.", (Throwable)se);
        }
        catch (RemoteException re) {
            LOG.error((Object)"There's an error in Confluence.", (Throwable)re);
        }
        catch (IOException ioe) {
            LOG.error((Object)"Can't talk to Confluence.", (Throwable)ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }
}

