/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugin.helper;

import com.atlassian.confluence.ConfluenceSoapService;
import com.atlassian.confluence.RemoteAttachment;
import com.atlassian.confluence.plugin.helper.AbstractHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.rpc.ServiceException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AttachmentHelper
extends AbstractHelper {
    private long id;
    private long parentId;
    private String title;
    private String contentType;
    private String fileName;
    private long contentLength;
    private String comment;
    private String creator;
    private Date creationDate;
    private byte[] content;

    public AttachmentHelper(long parentId, String fileName) {
        this.setParentId(parentId);
        this.setFileName(fileName);
    }

    public AttachmentHelper() {
        this(0L, null);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    private RemoteAttachment toRemoteAttachment() {
        RemoteAttachment remoteAttachment = new RemoteAttachment();
        Calendar creationDate = Calendar.getInstance();
        remoteAttachment.setComment(this.getComment());
        remoteAttachment.setContentType(this.getContentType());
        if (null != this.getCreationDate()) {
            creationDate.setTime(this.getCreationDate());
            remoteAttachment.setCreated(creationDate);
        }
        remoteAttachment.setCreator(this.getCreator());
        remoteAttachment.setFileName(this.getFileName());
        remoteAttachment.setFileSize(this.getContentLength());
        remoteAttachment.setId(this.getId());
        remoteAttachment.setPageId(this.getParentId());
        remoteAttachment.setTitle(this.getTitle());
        return remoteAttachment;
    }

    private void fromRemoteAttachment(RemoteAttachment remoteAttachment) {
        this.setComment(remoteAttachment.getComment());
        this.setContentType(remoteAttachment.getContentType());
        this.setCreationDate(remoteAttachment.getCreated().getTime());
        this.setCreator(remoteAttachment.getCreator());
        this.setFileName(remoteAttachment.getFileName());
        this.setContentLength(remoteAttachment.getFileSize());
        this.setId(remoteAttachment.getId());
        this.setParentId(remoteAttachment.getPageId());
        this.setTitle(remoteAttachment.getTitle());
    }

    private byte[] getBytesFromContent() throws IOException {
        if (null == this.getContent()) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)Math.max(0L, this.getContentLength()));
        IOUtils.copy((InputStream)new ByteArrayInputStream(this.getContent()), (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public boolean create() {
        if (0L < this.getId()) {
            throw new IllegalStateException("The attachment already has an ID.");
        }
        return this.saveOrUpdateAttachment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveOrUpdateAttachment() {
        String soapSessionToken = null;
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemoteAttachment remoteAttachment = confluenceSoapService.addAttachment(soapSessionToken, this.getParentId(), this.toRemoteAttachment(), this.getBytesFromContent());
            this.setId(remoteAttachment.getId());
            boolean bl = this.getId() > 0L;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read() {
        String soapSessionToken = null;
        this.checkUpdatePrerequisites();
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            RemoteAttachment remoteAttachment = confluenceSoapService.getAttachment(soapSessionToken, this.getParentId(), this.getFileName(), 0);
            this.fromRemoteAttachment(remoteAttachment);
            boolean success = 0L < this.getId();
            if (success) {
                this.setContent(confluenceSoapService.getAttachmentData(soapSessionToken, this.getParentId(), this.getFileName(), 0));
            }
            boolean bl = success;
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }

    private void checkUpdatePrerequisites() {
        if (0L >= this.getParentId()) {
            throw new IllegalStateException("Parent ID not specified.");
        }
        if (StringUtils.isBlank((String)this.getFileName())) {
            throw new IllegalStateException("Attachment file name not specified.");
        }
    }

    public boolean update() {
        return this.saveOrUpdateAttachment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete() {
        String soapSessionToken = null;
        this.checkUpdatePrerequisites();
        try {
            soapSessionToken = this.confluenceWebTester.loginToSoapService();
            ConfluenceSoapService confluenceSoapService = this.confluenceWebTester.getConfluenceSoapService();
            boolean bl = confluenceSoapService.removeAttachment(soapSessionToken, this.getParentId(), this.getFileName());
            return bl;
        }
        catch (MalformedURLException mUrlE) {
            this.handleInvalidSoapServiceEndpointException(mUrlE);
        }
        catch (ServiceException se) {
            this.handleInvalidSoapServiceException(se);
        }
        catch (RemoteException re) {
            this.handleRemoteException(re);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
        finally {
            this.confluenceWebTester.logoutFromSoapService(soapSessionToken);
        }
        return false;
    }
}

